/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import xaeroplus.Globals;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.drawing.DrawingCache;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.feature.render.line.Line;
import xaeroplus.module.Module;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.DrawingMode;

public class Drawing
extends Module {
    public final DrawingCache drawingCache = new DrawingCache("XaeroPlusDrawing");
    private Line inProgressLine = null;
    private int savedColorAlpha = 150;
    private final DrawingColorCycler drawingColorCycler = new DrawingColorCycler();
    private final int inProgressColorAlpha = 80;
    private static final int SNAP_THRESHOLD = 10;

    public DrawingColorCycler getDrawingColorCycler() {
        return this.drawingColorCycler;
    }

    @Override
    public void onEnable() {
        this.drawingCache.onEnable();
        Globals.drawManager.registry().register(DrawFeatureFactory.multiColorLines(this.getClass().getName() + "-saved", this::getSavedLines, () -> this.savedColorAlpha, () -> 0.5f, 50));
        Globals.drawManager.registry().register(DrawFeatureFactory.lines(this.getClass().getName() + "-in-progress", this::getInProgressLines, () -> this.drawingColorCycler.getColorInt(80), () -> 0.5f, 1));
        Globals.drawManager.registry().register(DrawFeatureFactory.multiColorChunkHighlights(this.getClass().getName() + "-highlights", this.drawingCache::getCacheMap, () -> this.savedColorAlpha, 50));
    }

    @EventHandler
    public void onTick(ClientTickEvent.Post event) {
        this.drawingCache.handleTick();
    }

    @EventHandler
    public void onWorldChange(XaeroWorldChangeEvent event) {
        this.drawingCache.handleWorldChange(event);
    }

    private Object2IntMap<Line> getSavedLines(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        return this.drawingCache.getLines(dimension);
    }

    private List<Line> getInProgressLines(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        Line l = this.inProgressLine;
        if (this.inProgressLine != null) {
            return List.of(l);
        }
        return Collections.emptyList();
    }

    public void addLine(Line line, int color) {
        if (line.length() < 2.0) {
            return;
        }
        this.drawingCache.addLine(line, color, Globals.getCurrentDimensionId());
    }

    public void addLine(Line line) {
        this.addLine(line, this.drawingColorCycler.getColorInt(80));
    }

    public void addInfiniteLine(Line line, int color) {
        if (line.length() < 2.0) {
            return;
        }
        this.drawingCache.addLine(line.extrapolateToWorldBorder(), color, Globals.getCurrentDimensionId());
    }

    public void addInfiniteLine(Line line) {
        this.addInfiniteLine(line, this.drawingColorCycler.getColorInt(80));
    }

    public void addHighlight(int chunkX, int chunkZ, int color) {
        this.drawingCache.addHighlight(chunkX, chunkZ, color, Globals.getCurrentDimensionId());
    }

    public void addHighlight(int chunkX, int chunkZ) {
        this.addHighlight(chunkX, chunkZ, this.drawingColorCycler.getColor().getColor());
    }

    public void removeHighlight(int chunkX, int chunkZ) {
        this.drawingCache.removeHighlight(chunkX, chunkZ, Globals.getCurrentDimensionId());
    }

    public void setInProgressLine(Line inProgressLine, DrawingMode drawingMode) {
        switch (drawingMode) {
            case LINE_SEGMENT: {
                this.inProgressLine = inProgressLine;
                break;
            }
            case INFINITE_LINE: {
                this.inProgressLine = inProgressLine.extrapolateToWorldBorder();
            }
        }
    }

    public void removeInProgressLine() {
        this.inProgressLine = null;
    }

    public void removeLine(int x, int z) {
        Object2IntMap<Line> lines = this.drawingCache.getLines(Globals.getCurrentDimensionId());
        int maxX = x + 16;
        int maxZ = z + 16;
        Line sqLine1 = new Line(x, z, maxX, z);
        Line sqLine2 = new Line(x, z, x, maxZ);
        Line sqLine3 = new Line(maxX, z, maxX, maxZ);
        Line sqLine4 = new Line(x, maxZ, maxX, maxZ);
        ArrayList<Line> toRemove = new ArrayList<Line>();
        ObjectIterator it = Object2IntMaps.fastIterator(lines);
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            Line line = (Line)entry.getKey();
            if (line.x1() < x && line.x2() < x || line.z1() < z && line.z2() < z || line.x1() > maxX && line.x2() > maxX || line.z1() > maxZ && line.z2() > maxZ || !this.linesIntersect(line, sqLine1) && !this.linesIntersect(line, sqLine2) && !this.linesIntersect(line, sqLine3) && !this.linesIntersect(line, sqLine4)) continue;
            toRemove.add(line);
        }
        for (Line line : toRemove) {
            this.drawingCache.removeLine(line, Globals.getCurrentDimensionId());
        }
    }

    private boolean linesIntersect(Line line1, Line line2) {
        int cz;
        double bx = line1.x2() - line1.x1();
        double bz = line1.z2() - line1.z1();
        double dx = line2.x2() - line2.x1();
        double dz = line2.z2() - line2.z1();
        double bDotDPerp = bx * dz - bz * dx;
        if (Math.round(bDotDPerp) == 0L) {
            return false;
        }
        int cx = line2.x1() - line1.x1();
        double t = ((double)cx * dz - (double)(cz = line2.z1() - line1.z1()) * dx) / bDotDPerp;
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        double u = ((double)cx * bz - (double)cz * bx) / bDotDPerp;
        return u >= 0.0 && u <= 1.0;
    }

    public void setOpacity(int opacity) {
        this.savedColorAlpha = opacity;
    }

    public Line snap(int x1, int z1, int x2, int z2, double scale) {
        double scalar = 1.0 / scale;
        int threshold = Mth.clamp((int)Mth.floor((double)(10.0 * scalar)), (int)10, (int)1000);
        int len = Mth.floor((double)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(z2 - z1, 2.0)));
        if (len <= threshold) {
            return new Line(x1, z1, x2, z2);
        }
        int xDelta = Math.abs(x2 - x1);
        int zDelta = Math.abs(z2 - z1);
        if (xDelta < threshold) {
            return new Line(x1, z1, x1, z2);
        }
        if (zDelta < threshold) {
            return new Line(x1, z1, x2, z1);
        }
        int dDelta = Math.abs(xDelta - zDelta);
        if (dDelta != 0 && dDelta < threshold) {
            if (zDelta < xDelta) {
                int xSignum = x2 - x1 >= 0 ? 1 : -1;
                return new Line(x1, z1, x1 + zDelta * xSignum, z2);
            }
            if (xDelta < zDelta) {
                int zSignum = z2 - z1 >= 0 ? 1 : -1;
                return new Line(x1, z1, x2, z1 + zDelta * zSignum);
            }
        }
        return new Line(x1, z1, x2, z2);
    }

    public static final class DrawingColorCycler {
        private int index = 0;

        public void setColor(ColorHelper.HighlightColor color) {
            this.index = color.ordinal();
        }

        public ColorHelper.HighlightColor getColor() {
            return ColorHelper.HighlightColor.fromIndex(this.index);
        }

        public int getColorInt(int alpha) {
            int c = ColorHelper.HighlightColor.fromIndex(this.index).getColor();
            return ColorHelper.getColorWithAlpha(c, alpha);
        }

        public void next() {
            ++this.index;
            if (this.index >= ColorHelper.HighlightColor.VALUES.length) {
                this.index = 0;
            }
        }
    }
}

