/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.waste.of.time.storage.cache.HotCache;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.WorldToolsHelper;

public class WorldTools
extends Module {
    private int worldToolsColor = ColorHelper.getColor(0, 255, 0, 100);

    @Override
    public void onEnable() {
        if (!WorldToolsHelper.isWorldToolsPresent()) {
            return;
        }
        Globals.drawManager.registry().register(DrawFeatureFactory.asyncChunkHighlights(this.getClass().getName(), this::getWindowedHighlightsSnapshot, this::getWorldToolsColor));
    }

    @Override
    public void onDisable() {
        Globals.drawManager.registry().unregister(this.getClass().getName());
    }

    public boolean isChunkDownloaded(int x, int z, ResourceKey<Level> dimension) {
        return WorldToolsHelper.isDownloading() && dimension == ChunkUtils.getActualDimension() && HotCache.INSTANCE.isChunkSaved(x, z);
    }

    public Long2LongMap getWindowedHighlightsSnapshot(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        int minChunkX = ChunkUtils.regionCoordToChunkCoord(windowRegionX - windowRegionSize);
        int maxChunkX = ChunkUtils.regionCoordToChunkCoord(windowRegionX + windowRegionSize);
        int minChunkZ = ChunkUtils.regionCoordToChunkCoord(windowRegionZ - windowRegionSize);
        int maxChunkZ = ChunkUtils.regionCoordToChunkCoord(windowRegionZ + windowRegionSize);
        Long2LongOpenHashMap chunks = new Long2LongOpenHashMap(8);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                if (!this.isChunkDownloaded(x, z, dimension)) continue;
                chunks.put(ChunkUtils.chunkPosToLong(x, z), 0L);
            }
        }
        return chunks;
    }

    public int getWorldToolsColor() {
        return this.worldToolsColor;
    }

    public void setRgbColor(int color) {
        this.worldToolsColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.worldToolsAlphaSetting.getAsInt());
    }

    public void setAlpha(double alpha) {
        this.worldToolsColor = ColorHelper.getColorWithAlpha(this.worldToolsColor, (int)alpha);
    }
}

