/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import it.unimi.dsi.fastutil.doubles.DoubleArrayFIFOQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;

public class WaypointEtaCalculator {
    public static final WaypointEtaCalculator INSTANCE = new WaypointEtaCalculator();
    private long lastSpeedUpdate = 0L;
    private DoubleArrayFIFOQueue speedQueue = new DoubleArrayFIFOQueue(15);
    private int bufferLen = 15;

    public String getEtaTextSuffix(Waypoint waypoint) {
        long eta = this.getEtaSecondsToReachWaypoint(waypoint);
        if (eta <= 0L) {
            return "";
        }
        Object etaText = " - ";
        if (eta > 86400L) {
            int days = (int)(eta / 86400L);
            int hours = (int)(eta % 86400L / 3600L);
            etaText = (String)etaText + days + "d";
            if (hours > 0) {
                etaText = (String)etaText + " " + hours + "h";
            }
        } else if (eta > 3600L) {
            int hours = (int)(eta / 3600L);
            int minutes = (int)(eta % 3600L / 60L);
            etaText = (String)etaText + hours + "h";
            if (minutes > 0) {
                etaText = (String)etaText + " " + minutes + "m";
            }
        } else if (eta > 60L) {
            int minutes = (int)(eta / 60L);
            int seconds = (int)(eta % 60L);
            etaText = (String)etaText + minutes + "m";
            if (seconds > 0) {
                etaText = (String)etaText + " " + seconds + "s";
            }
        } else {
            etaText = (String)etaText + eta + "s";
        }
        return etaText;
    }

    public long getEtaSecondsToReachWaypoint(Waypoint waypoint) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return 0L;
        }
        try {
            Vec3 playerVec = mc.player.position();
            MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return 0L;
            }
            double dimDiv = minimapSession.getDimensionHelper().getDimensionDivision(minimapSession.getWorldManager().getCurrentWorld());
            int wpX = waypoint.getX(dimDiv);
            int wpZ = waypoint.getZ(dimDiv);
            double directionX = (double)wpX - playerVec.x;
            double directionZ = (double)wpZ - playerVec.z;
            double movementX = playerVec.x - mc.player.xOld;
            double movementZ = playerVec.z - mc.player.zOld;
            double dot = directionX * movementX + directionZ * movementZ;
            double distance = Math.sqrt(directionX * directionX + directionZ * directionZ);
            double speed = this.speedQueue.isEmpty() ? 0.0 : this.xaeroPlus$avgSpeed(this.speedQueue);
            double cos = dot / (distance * speed);
            double time = distance / speed;
            double etaTicks = time / cos;
            double etaSeconds = etaTicks / 20.0;
            long updateDeltaMs = System.currentTimeMillis() - this.lastSpeedUpdate;
            if (updateDeltaMs >= 50L) {
                this.lastSpeedUpdate = System.currentTimeMillis();
                double s = Math.sqrt(movementX * movementX + movementZ * movementZ);
                if (s > 0.0 || mc.player.tickCount % 4 == 0) {
                    this.speedQueue.enqueue(s);
                } else if (!this.speedQueue.isEmpty()) {
                    this.speedQueue.dequeueDouble();
                }
                while (this.speedQueue.size() > this.bufferLen) {
                    this.speedQueue.dequeueDouble();
                }
            }
            if (etaSeconds == Double.POSITIVE_INFINITY || etaSeconds == Double.NEGATIVE_INFINITY || Double.isNaN(etaSeconds)) {
                return 0L;
            }
            return (long)etaSeconds;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private double xaeroPlus$avgSpeed(DoubleArrayFIFOQueue speedQueue) {
        double sum = 0.0;
        for (int i = 0; i < speedQueue.size(); ++i) {
            double v = speedQueue.dequeueDouble();
            speedQueue.enqueue(v);
            sum += v;
        }
        double s = sum / (double)speedQueue.size();
        if (s < 0.05) {
            return 0.0;
        }
        return s;
    }

    public void updateBufferLen(double d) {
        this.bufferLen = Mth.clamp((int)((int)d), (int)1, (int)100);
        this.speedQueue = new DoubleArrayFIFOQueue(this.bufferLen + 5);
    }
}

