/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.drawing;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.drawing.db.DrawingDatabase;
import xaeroplus.feature.highlights.ChunkHighlightBaseCacheHandler;
import xaeroplus.util.ChunkUtils;

public class DrawingHighlightCacheDimensionHandler
extends ChunkHighlightBaseCacheHandler {
    private final ResourceKey<Level> dimension;
    private int windowRegionX = 0;
    private int windowRegionZ = 0;
    private int windowRegionSize = 0;
    private final DrawingDatabase database;
    private final ListeningExecutorService dbExecutor;
    public final LongSet staleChunks = new LongOpenHashSet();
    ListenableFuture<?> windowMoveFuture = Futures.immediateVoidFuture();

    public DrawingHighlightCacheDimensionHandler(ResourceKey<Level> dimension, DrawingDatabase database, ListeningExecutorService dbExecutor) {
        this.dimension = dimension;
        this.database = database;
        this.dbExecutor = dbExecutor;
    }

    public synchronized void setWindow(int regionX, int regionZ, int regionSize) {
        boolean windowChanged;
        boolean bl = windowChanged = regionX != this.windowRegionX || regionZ != this.windowRegionZ || regionSize != this.windowRegionSize;
        if (windowChanged && !this.windowMoveFuture.isDone() && (regionX != 0 || regionZ != 0 || regionSize != 0)) {
            XaeroPlus.LOGGER.debug("Rejecting window move to: [{} {} {}] from: [{} {} {}]", new Object[]{regionX, regionZ, regionSize, this.windowRegionX, this.windowRegionZ, this.windowRegionSize});
            return;
        }
        int prevWindowRegionX = this.windowRegionX;
        int prevWindowRegionZ = this.windowRegionZ;
        int prevWindowRegionSize = this.windowRegionSize;
        this.windowRegionX = regionX;
        this.windowRegionZ = regionZ;
        this.windowRegionSize = regionSize;
        if (windowChanged) {
            try {
                this.windowMoveFuture = this.moveWindow0(regionX, regionZ, regionSize, prevWindowRegionX, prevWindowRegionZ, prevWindowRegionSize);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed submitting move window task for {} disk cache dimension: {}", new Object[]{this.database.databaseName, this.dimension.location(), e});
            }
        }
    }

    private ListenableFuture<?> moveWindow0(int windowRegionX, int windowRegionZ, int windowRegionSize, int prevWindowRegionX, int prevWindowRegionZ, int prevWindowRegionSize) {
        ListenableFuture loadDataFuture = this.dbExecutor.submit(() -> this.loadUpdatedWindowFromDatabase(windowRegionX, windowRegionZ, windowRegionSize, prevWindowRegionX, prevWindowRegionZ, prevWindowRegionSize));
        Futures.addCallback((ListenableFuture)loadDataFuture, (FutureCallback)new WindowDataLoadFutureCallback(), (Executor)this.mc);
        ListenableFuture<?> removeDataFuture = this.flushChunksOutsideWindow(windowRegionX, windowRegionZ, windowRegionSize);
        return Futures.allAsList((ListenableFuture[])new ListenableFuture[]{loadDataFuture, removeDataFuture});
    }

    private Long2LongMap loadUpdatedWindowFromDatabase(int windowRegionX, int windowRegionZ, int windowRegionSize, int prevWindowRegionX, int prevWindowRegionZ, int prevWindowRegionSize) {
        Long2LongOpenHashMap dataBuf = new Long2LongOpenHashMap();
        this.database.getHighlightsInWindow(this.dimension, windowRegionX - windowRegionSize, windowRegionX + windowRegionSize, windowRegionZ - windowRegionSize, windowRegionZ + windowRegionSize, (arg_0, arg_1, arg_2) -> DrawingHighlightCacheDimensionHandler.lambda$loadUpdatedWindowFromDatabase$1((Long2LongMap)dataBuf, arg_0, arg_1, arg_2));
        return dataBuf;
    }

    private ListenableFuture<?> flushChunksOutsideWindow(int windowRegionX, int windowRegionZ, int windowRegionSize) {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("removeChunksOutsideWindow must be called on the main thread");
        }
        Long2LongOpenHashMap dataBuf = new Long2LongOpenHashMap();
        int chunkXMin = ChunkUtils.regionCoordToChunkCoord(windowRegionX - windowRegionSize);
        int chunkXMax = ChunkUtils.regionCoordToChunkCoord(windowRegionX + windowRegionSize);
        int chunkZMin = ChunkUtils.regionCoordToChunkCoord(windowRegionZ - windowRegionSize);
        int chunkZMax = ChunkUtils.regionCoordToChunkCoord(windowRegionZ + windowRegionSize);
        LongIterator it = this.chunks.keySet().longIterator();
        while (it.hasNext()) {
            long chunkPos = it.nextLong();
            int chunkX = ChunkUtils.longToChunkX(chunkPos);
            int chunkZ = ChunkUtils.longToChunkZ(chunkPos);
            if (chunkX >= chunkXMin && chunkX <= chunkXMax && chunkZ >= chunkZMin && chunkZ <= chunkZMax) continue;
            if (this.staleChunks.contains(chunkPos)) {
                dataBuf.put(chunkPos, this.chunks.get(chunkPos));
            }
            it.remove();
        }
        return this.dbExecutor.submit(() -> this.lambda$flushChunksOutsideWindow$2((Long2LongMap)dataBuf));
    }

    public Long2LongMap collectStaleHighlightsToWrite() {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("collectStaleHighlightsToWrite must be called on the main thread");
        }
        if (this.staleChunks.isEmpty()) {
            return Long2LongMaps.EMPTY_MAP;
        }
        Long2LongOpenHashMap chunksToWrite = new Long2LongOpenHashMap(this.staleChunks.size());
        LongIterator it = this.staleChunks.longIterator();
        while (it.hasNext()) {
            long chunkPos = it.nextLong();
            long foundTime = this.chunks.get(chunkPos);
            if (foundTime != this.chunks.defaultReturnValue()) {
                chunksToWrite.put(chunkPos, foundTime);
            }
            it.remove();
        }
        return chunksToWrite;
    }

    public ListenableFuture<?> writeDataToDatabase(Long2LongMap toWrite) {
        try {
            return this.dbExecutor.submit(() -> this.database.insertHighlightList(toWrite, this.dimension));
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed to submit db write task for {} disk cache dimension: {}", new Object[]{this.database.databaseName, this.dimension.location(), e});
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public ListenableFuture<?> writeStaleHighlightsToDatabase() {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("writeStaleHighlightsToDatabase must be called on the main thread");
        }
        Long2LongMap toWrite = this.collectStaleHighlightsToWrite();
        if (toWrite.isEmpty()) {
            return Futures.immediateVoidFuture();
        }
        return this.writeDataToDatabase(toWrite);
    }

    @Override
    public void addHighlight(int x, int z, long foundTime) {
        super.addHighlight(x, z, foundTime);
        this.staleChunks.add(ChunkUtils.chunkPosToLong(x, z));
    }

    @Override
    public void addHighlight(int x, int z, ResourceKey<Level> dimensionId) {
        super.addHighlight(x, z, dimensionId);
        this.staleChunks.add(ChunkUtils.chunkPosToLong(x, z));
    }

    @Override
    public void removeHighlight(int x, int z) {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("removeHighlight must be called on the main thread!");
        }
        long key = ChunkUtils.chunkPosToLong(x, z);
        if (this.chunks.containsKey(key)) {
            super.removeHighlight(x, z);
            this.staleChunks.add(key);
            this.dbExecutor.execute(() -> this.database.removeHighlight(x, z, this.dimension));
        }
    }

    @Override
    public CompletableFuture<Long2LongMap> getHighlightsInCustomWindow(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        return this.submitTickTask(this::writeStaleHighlightsToDatabase).thenApplyAsync(v -> {
            int regionXMin = windowRegionX - windowRegionSize;
            int regionZMin = windowRegionZ - windowRegionSize;
            int regionXMax = windowRegionX + windowRegionSize;
            int regionZMax = windowRegionZ + windowRegionSize;
            Long2LongOpenHashMap resultMap = new Long2LongOpenHashMap();
            ListenableFuture dbLoadFuture = this.dbExecutor.submit(() -> this.database.getHighlightsInWindow(dimension, regionXMin, regionXMax, regionZMin, regionZMax, (chunkX, chunkZ, foundTime) -> resultMap.put(ChunkUtils.chunkPosToLong(chunkX, chunkZ), (long)foundTime)));
            try {
                dbLoadFuture.get();
                return resultMap;
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed to load highlights in custom window for {} disk cache dimension: {}", new Object[]{this.database.databaseName, this.dimension.location(), e});
                return Long2LongMaps.EMPTY_MAP;
            }
        });
    }

    @Override
    public void handleWorldChange(XaeroWorldChangeEvent event) {
    }

    @Override
    public void handleTick() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    private /* synthetic */ void lambda$flushChunksOutsideWindow$2(Long2LongMap dataBuf) {
        this.database.insertHighlightList(dataBuf, this.dimension);
    }

    private static /* synthetic */ void lambda$loadUpdatedWindowFromDatabase$1(Long2LongMap dataBuf, int chunkX, int chunkZ, int foundTime) {
        dataBuf.put(ChunkUtils.chunkPosToLong(chunkX, chunkZ), (long)foundTime);
    }

    private final class WindowDataLoadFutureCallback
    implements FutureCallback<Long2LongMap> {
        private WindowDataLoadFutureCallback() {
        }

        public void onSuccess(Long2LongMap dataBuf) {
            if (!DrawingHighlightCacheDimensionHandler.this.mc.isSameThread()) {
                XaeroPlus.LOGGER.error("WindowDataLoadFutureCallback must be called on the main thread");
            }
            if (dataBuf.isEmpty()) {
                return;
            }
            DrawingHighlightCacheDimensionHandler.this.chunks.putAll((Map)dataBuf);
        }

        public void onFailure(Throwable t) {
            XaeroPlus.LOGGER.error("Error while moving window for {} disk cache dimension: {}", new Object[]{DrawingHighlightCacheDimensionHandler.this.database.databaseName, DrawingHighlightCacheDimensionHandler.this.dimension.location(), t});
        }
    }
}

