/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.dropdown.rightclick.RightClickOption;
import xaero.map.misc.Misc;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointReader;
import xaeroplus.mixin.client.AccessorRightClickOption;
import xaeroplus.settings.Settings;
import xaeroplus.util.BaritoneExecutor;
import xaeroplus.util.BaritoneHelper;

@Mixin(value={WaypointReader.class}, remap=false)
public class MixinWaypointReader {
    @Inject(method={"getRightClickOptions(Lxaero/map/mods/gui/Waypoint;Lxaero/map/gui/IRightClickableElement;)Ljava/util/ArrayList;"}, at={@At(value="RETURN")})
    public void getRightClickOptionsReturn(final Waypoint element, IRightClickableElement target, CallbackInfoReturnable<ArrayList<RightClickOption>> cir) {
        if (!Settings.REGISTRY.worldMapUIAdditions.get()) {
            return;
        }
        ArrayList options = (ArrayList)cir.getReturnValue();
        int index = 3;
        options.add(index++, new RightClickOption(this, "xaeroplus.gui.world_map.copy_coordinates", options.size(), target){

            public void onAction(Screen screen) {
                Minecraft.getInstance().keyboardHandler.setClipboard(element.getX() + " " + element.getY() + " " + element.getZ());
            }
        });
        if (BaritoneHelper.isBaritonePresent()) {
            final int goalX = Mth.floor((double)(element.getRenderX() - 0.5));
            final int goalZ = Mth.floor((double)(element.getRenderZ() - 0.5));
            options.add(index++, new RightClickOption(this, "xaeroplus.gui.world_map.baritone_goal_here", options.size(), target){

                public void onAction(Screen screen) {
                    BaritoneExecutor.goal(goalX, goalZ);
                }
            }.setNameFormatArgs(new Object[]{Misc.getKeyName((KeyMapping)Settings.REGISTRY.worldMapBaritoneGoalHereKeybindSetting.getKeyBinding())}));
            options.add(index++, new RightClickOption(this, "xaeroplus.gui.world_map.baritone_path_here", options.size(), target){

                public void onAction(Screen screen) {
                    BaritoneExecutor.path(goalX, goalZ);
                }
            }.setNameFormatArgs(new Object[]{Misc.getKeyName((KeyMapping)Settings.REGISTRY.worldMapBaritonePathHereKeybindSetting.getKeyBinding())}));
            if (BaritoneHelper.isBaritoneElytraPresent()) {
                options.addAll(5, Arrays.asList(new RightClickOption(this, "xaeroplus.gui.world_map.baritone_elytra_here", options.size(), target){

                    public void onAction(Screen screen) {
                        BaritoneExecutor.elytra(goalX, goalZ);
                    }
                }.setNameFormatArgs(new Object[]{Misc.getKeyName((KeyMapping)Settings.REGISTRY.worldMapBaritoneElytraHereKeybindSetting.getKeyBinding())})));
            }
        }
        if (Settings.REGISTRY.disableWaypointSharing.get()) {
            options.removeIf(option -> ((AccessorRightClickOption)option).getName().equals("gui.xaero_right_click_waypoint_share"));
        }
        if (!Settings.REGISTRY.showCoordsInRightClickOptions.get()) {
            options.removeIf(option -> {
                String name = ((AccessorRightClickOption)option).getName();
                return name.startsWith("X: ");
            });
        }
        if (Settings.REGISTRY.disableTeleportation.get()) {
            options.removeIf(option -> ((AccessorRightClickOption)option).getName().equals("gui.xaero_right_click_waypoint_teleport"));
        }
    }
}

