/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.module.impl.SpawnChunksBase;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ChunkUtils;

public class SpawnChunks
extends SpawnChunksBase {
    @EventHandler
    public void onClientTick(ClientTickEvent.Post event) {
        this.onClientTick();
    }

    @Override
    public ResourceKey<Level> dimension() {
        return Level.OVERWORLD;
    }

    @Override
    int getSpawnRadius() {
        int spawnChunkRadius = 2;
        if (this.mc.hasSingleplayerServer()) {
            try {
                spawnChunkRadius = this.mc.getSingleplayerServer().getLevel(Level.OVERWORLD).getGameRules().getInt(GameRules.RULE_SPAWN_RADIUS);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed to get spawn radius from singleplayer server", (Throwable)e);
            }
        }
        return spawnChunkRadius;
    }

    @Override
    long getSpawnChunkPos() {
        ClientLevel level = this.mc.level;
        if (level == null) {
            return ChunkUtils.chunkPosToLong(0, 0);
        }
        ClientLevel.ClientLevelData levelData = level.getLevelData();
        if (levelData == null) {
            return ChunkUtils.chunkPosToLong(0, 0);
        }
        int spawnBlockX = levelData.getRespawnData().pos().getX();
        int spawnBlockZ = levelData.getRespawnData().pos().getZ();
        int spawnChunkX = ChunkUtils.posToChunkPos(spawnBlockX);
        int spawnChunkZ = ChunkUtils.posToChunkPos(spawnBlockZ);
        return ChunkUtils.chunkPosToLong(spawnChunkX, spawnChunkZ);
    }
}

