/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import xaeroplus.feature.render.buffered.Model;
import xaeroplus.module.impl.FpsLimiter;
import xaeroplus.settings.Settings;

public class BufferedComponent {
    private static final Minecraft mc = Minecraft.m_91087_();
    private Model model = null;
    private final RenderTarget renderTarget = new TextureTarget(100, 100, true, false);
    private long nextRenderCapture = System.currentTimeMillis();
    private final IntSupplier fpsLimitSupplier;
    private final Matrix4f modelViewMatrix = new Matrix4f(RenderSystem.m_157190_());

    public BufferedComponent(IntSupplier fpsLimitSupplier) {
        this.fpsLimitSupplier = fpsLimitSupplier;
    }

    private void refreshModel(int screenWidth, int screenHeight) {
        if (this.model != null) {
            this.model.close();
        }
        Vector3f[] posMatrix = new Vector3f[]{new Vector3f(0.0f, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        Model.Vector2f[] texUvMatrix = new Model.Vector2f[]{new Model.Vector2f(0.0f, 0.0f), new Model.Vector2f(1.0f, 0.0f), new Model.Vector2f(1.0f, 1.0f), new Model.Vector2f(0.0f, 1.0f)};
        this.model = new Model(posMatrix, texUvMatrix);
    }

    public boolean render() {
        int windowWidth = mc.m_91268_().m_85441_();
        int windowHeight = mc.m_91268_().m_85442_();
        boolean forceRender = false;
        if (this.renderTarget.f_83915_ != windowWidth || this.renderTarget.f_83916_ != windowHeight) {
            this.renderTarget.m_83941_(windowWidth, windowHeight, true);
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (this.model == null) {
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (forceRender || System.currentTimeMillis() > this.nextRenderCapture) {
            this.renderTarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
            this.renderTarget.m_83954_(false);
            this.renderTarget.m_83947_(false);
            FpsLimiter.renderTargetOverwrite = this.renderTarget;
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.renderTarget.m_83947_(false);
            return false;
        }
        this.renderBufferedTexture(this.renderTarget.m_83975_());
        return true;
    }

    public void postRender() {
        FpsLimiter.renderTargetOverwrite = null;
        this.renderTarget.m_83970_();
        mc.m_91385_().m_83947_(true);
        this.nextRenderCapture = System.currentTimeMillis() + (long)(1000 / this.fpsLimitSupplier.getAsInt());
        this.renderBufferedTexture(this.renderTarget.m_83975_());
    }

    private void renderBufferedTexture(int textureId) {
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)textureId);
        this.modelViewMatrix.m_162210_(RenderSystem.m_157190_());
        this.modelViewMatrix.m_27648_(new Vector3f(0.0f, 0.0f, (float)Settings.REGISTRY.minimapRenderZOffsetSetting.get()));
        float guiScale = (float)Math.max(1.0, mc.m_91268_().m_85449_());
        float scalar = 1.0f / guiScale;
        Matrix4f scaleMatrix = Matrix4f.m_27632_((float)scalar, (float)scalar, (float)scalar);
        this.modelViewMatrix.m_27644_(scaleMatrix);
        this.model.draw(this.modelViewMatrix);
    }
}

