/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import xaero.map.highlight.AbstractHighlighter;
import xaero.map.highlight.DimensionHighlighterHandler;
import xaero.map.highlight.HighlighterRegistry;

@Mixin(value={DimensionHighlighterHandler.class}, remap=false)
public class MixinDimensionHighlighterHandler {
    @Final
    @Shadow
    private ResourceKey<Level> dimension;
    @Final
    @Shadow
    private HighlighterRegistry registry;

    @Overwrite
    public boolean shouldApplyRegionHighlights(int regionX, int regionZ, boolean discovered) {
        ResourceKey<Level> dimension = this.dimension;
        List highlighters = this.registry.getHighlighters();
        try {
            for (int i = 0; i < highlighters.size(); ++i) {
                AbstractHighlighter hl = (AbstractHighlighter)highlighters.get(i);
                if (!discovered && !hl.isCoveringOutsideDiscovered() || !hl.regionHasHighlights(dimension, regionX, regionZ)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

