/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.misc.KeySortableByOther;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.map.misc.Misc;
import xaeroplus.settings.Settings;

@Mixin(value={GuiWaypoints.class}, remap=false)
public abstract class MixinGuiWaypoints
extends ScreenBase {
    @Unique
    private EditBox searchField;
    @Unique
    private final int TOGGLE_ALL_ID = 69;
    @Unique
    private MySmallButton toggleAllButton;
    @Unique
    private String waypointsSearchFilter = "";
    @Shadow
    private MinimapWorld displayedWorld;
    @Shadow
    private ArrayList<Waypoint> waypointsSorted;
    @Shadow
    private MinimapSession session;
    @Shadow
    private ConcurrentSkipListSet<Integer> selectedListSet;

    @Shadow
    protected abstract boolean isOneSelected();

    protected MixinGuiWaypoints(IXaeroMinimap modMain, Screen parent, Screen escape, Component titleIn) {
        super(modMain, parent, escape, titleIn);
    }

    public void m_86600_() {
        super.m_86600_();
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        this.searchField.m_94120_();
    }

    @Inject(method={"init"}, at={@At(value="RETURN")}, remap=true)
    public void initGui(CallbackInfo ci) {
        this.waypointsSearchFilter = "";
        this.searchField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 297, 32, 80, 20, (Component)Component.m_237113_((String)"Search"));
        this.searchField.m_94144_("");
        this.searchField.m_94178_(true);
        this.searchField.m_94192_(0);
        this.searchField.m_94196_(0);
        this.toggleAllButton = new MySmallButton(69, this.f_96543_ / 2 + 213, this.f_96544_ - 53, (Component)Component.m_237115_((String)"xaeroplus.gui.waypoints.toggle_enable_all"), b -> this.waypointsSorted.stream().findFirst().ifPresent(firstWaypoint -> {
            boolean firstIsEnabled = firstWaypoint.isDisabled();
            this.waypointsSorted.forEach(waypoint -> waypoint.setDisabled(!firstIsEnabled));
        }));
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        this.m_7787_((GuiEventListener)this.searchField);
        this.m_7522_((GuiEventListener)this.searchField);
        this.m_142416_((GuiEventListener)this.toggleAllButton);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;mouseClicked(DDI)Z", shift=At.Shift.AFTER)}, remap=true)
    public void mouseClickedInject(double x, double y, int button, CallbackInfoReturnable<Boolean> cir) {
        boolean dropDownClosed;
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        boolean bl = dropDownClosed = this.openDropdown == null;
        if (dropDownClosed) {
            if (this.searchField.m_6375_(x, y, button)) {
                this.searchField.m_94178_(true);
                this.searchField.m_94201_();
                this.searchField.m_94186_(true);
            } else {
                this.searchField.m_94178_(false);
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;keyPressed(III)Z", shift=At.Shift.AFTER)}, remap=true, cancellable=true)
    public void keyTypedInject(int keycode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        if (this.searchField.m_93696_()) {
            this.updateSearch();
            cir.setReturnValue((Object)true);
        }
    }

    public boolean m_5534_(char c, int i) {
        boolean result = super.m_5534_(c, i);
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return result;
        }
        this.updateSearch();
        return result;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;render(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", shift=At.Shift.AFTER)}, remap=true)
    public void drawScreenInject(PoseStack guiGraphics, int mouseX, int mouseY, float partial, CallbackInfo ci) {
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        if (!this.searchField.m_93696_() && this.searchField.m_94155_().isEmpty()) {
            Misc.setFieldText((EditBox)this.searchField, (String)I18n.m_118938_((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), (int)-11184811);
            this.searchField.m_94198_();
        }
        this.searchField.m_6305_(guiGraphics, mouseX, mouseY, partial);
        if (!this.searchField.m_93696_()) {
            Misc.setFieldText((EditBox)this.searchField, (String)this.waypointsSearchFilter);
        }
    }

    @Redirect(method={"updateButtons"}, at=@At(value="INVOKE", target="Lxaero/common/gui/GuiWaypoints;isOneSelected()Z"))
    public boolean shareButtonRedirect(GuiWaypoints instance) {
        if (Settings.REGISTRY.disableWaypointSharing.get()) {
            return false;
        }
        return this.isOneSelected();
    }

    @Unique
    private void updateSearch() {
        String newValue;
        if (this.searchField.m_93696_() && !this.waypointsSearchFilter.equals(newValue = this.searchField.m_94155_())) {
            this.waypointsSearchFilter = this.searchField.m_94155_();
            this.selectedListSet.clear();
            this.updateSortedList();
        }
    }

    @Overwrite
    private void updateSortedList() {
        WaypointsSort sortType = this.displayedWorld.getRootConfig().getSortType();
        Iterable waypointsList = this.displayedWorld.getCurrentWaypointSet().getWaypoints();
        GuiWaypoints.distanceDivided = this.session.getDimensionHelper().getDimensionDivision(this.displayedWorld);
        Camera camera = this.f_96541_.f_91063_.m_109153_();
        ArrayList<Waypoint> disabledWaypoints = new ArrayList<Waypoint>();
        ArrayList<Waypoint> enabledWaypoints = new ArrayList<Waypoint>();
        for (Waypoint w : waypointsList) {
            if (w.isDisabled()) {
                disabledWaypoints.add(w);
                continue;
            }
            enabledWaypoints.add(w);
        }
        if (!this.waypointsSearchFilter.isEmpty()) {
            enabledWaypoints.removeIf(waypoint -> !waypoint.getName().toLowerCase().contains(this.waypointsSearchFilter.toLowerCase()));
            disabledWaypoints.removeIf(waypoint -> !waypoint.getName().toLowerCase().contains(this.waypointsSearchFilter.toLowerCase()));
        }
        this.waypointsSorted = new ArrayList();
        this.waypointsSorted.addAll(this.sortWaypoints(enabledWaypoints, sortType, camera));
        this.waypointsSorted.addAll(this.sortWaypoints(disabledWaypoints, sortType, camera));
    }

    @Unique
    private List<Waypoint> sortWaypoints(List<Waypoint> waypointsList, WaypointsSort sortType, Camera camera) {
        ArrayList<Waypoint> waypointsSorted = new ArrayList<Waypoint>();
        ArrayList<KeySortableByOther> sortableKeys = new ArrayList<KeySortableByOther>();
        for (Waypoint w : waypointsList) {
            Object sortVal = 0;
            switch (sortType) {
                case NONE: {
                    break;
                }
                case ANGLE: {
                    sortVal = -w.getComparisonAngleCos(camera, GuiWaypoints.distanceDivided);
                    break;
                }
                case COLOR: {
                    sortVal = w.getWaypointColor();
                    break;
                }
                case NAME: {
                    sortVal = w.getComparisonName();
                    break;
                }
                case SYMBOL: {
                    sortVal = w.getInitials();
                    break;
                }
                case DISTANCE: {
                    sortVal = w.getComparisonDistance(camera, GuiWaypoints.distanceDivided);
                }
            }
            sortableKeys.add(new KeySortableByOther((Object)w, new Comparable[]{sortVal}));
        }
        Collections.sort(sortableKeys);
        for (KeySortableByOther k : sortableKeys) {
            waypointsSorted.add((Waypoint)k.getKey());
        }
        if (this.displayedWorld.getContainer().getRootConfig().isSortReversed()) {
            Collections.reverse(waypointsSorted);
        }
        return waypointsSorted;
    }
}

