/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.events.ClientEvents;
import xaeroplus.settings.Settings;

@Mixin(value={ClientEvents.class}, remap=false)
public abstract class MixinClientEvents {
    @Inject(method={"handleClientSystemChatReceivedEvent"}, at={@At(value="HEAD")}, cancellable=true)
    public void onSystemChatReceived(Component component, CallbackInfoReturnable<Boolean> cir) {
        if (component == null) {
            return;
        }
        if (Settings.REGISTRY.disableReceivingWaypoints.get()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"handleClientPlayerChatReceivedEvent"}, at={@At(value="HEAD")}, cancellable=true)
    public void onPlayerChatReceived(ChatType.Bound chatType, Component component, PlayerInfo playerInfo, CallbackInfoReturnable<Boolean> cir) {
        if (component == null) {
            return;
        }
        if (Settings.REGISTRY.disableReceivingWaypoints.get()) {
            cir.setReturnValue((Object)false);
        }
    }
}

