/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.gui.GuiWaypoints;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaeroplus.feature.extensions.SyncedWaypoint;
import xaeroplus.mixin.client.AccessorGuiWaypoints;
import xaeroplus.settings.Settings;

@Mixin(targets={"xaero.common.gui.GuiWaypoints$List"}, remap=false)
public abstract class MixinGuiWaypointsList {
    @Unique
    private final WaypointSet waypointsSortedSet = WaypointSet.Builder.begin().setName("xp-wp-sorted").build();
    @Unique
    private GuiWaypoints thisGuiWaypoints;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void init(GuiWaypoints this$0, CallbackInfo ci) throws NoSuchFieldException, IllegalAccessException {
        this.thisGuiWaypoints = this$0;
    }

    @Inject(method={"getWaypointCount"}, at={@At(value="HEAD")}, cancellable=true)
    public void getWaypointCount(CallbackInfoReturnable<Integer> cir) {
        try {
            int size = ((AccessorGuiWaypoints)this.thisGuiWaypoints).getWaypointsSorted().size();
            cir.setReturnValue((Object)size);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Redirect(method={"getWaypoint"}, at=@At(value="INVOKE", target="Lxaero/hud/minimap/world/MinimapWorld;getCurrentWaypointSet()Lxaero/hud/minimap/waypoint/set/WaypointSet;"))
    public WaypointSet getWaypointList(MinimapWorld instance) {
        this.waypointsSortedSet.clear();
        this.waypointsSortedSet.addAll(((AccessorGuiWaypoints)this.thisGuiWaypoints).getWaypointsSorted());
        return this.waypointsSortedSet;
    }

    @Inject(method={"drawWaypointSlot"}, at={@At(value="INVOKE", target="Lxaero/common/minimap/waypoints/Waypoint;isGlobal()Z")}, remap=false)
    public void shiftIconsLeft(CallbackInfo ci, @Local(name={"rectX"}) LocalIntRef rectX) {
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        rectX.set(rectX.get() - 30);
    }

    @ModifyExpressionValue(method={"drawWaypointSlot"}, at={@At(value="CONSTANT", args={"stringValue=gui.xaero_temporary"})})
    public String syncedWaypointTranslationKey(String original, @Local(argsOnly=true) Waypoint wp) {
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return original;
        }
        if (wp instanceof SyncedWaypoint) {
            return "xaeroplus.gui.waypoints.synced_waypoint";
        }
        return original;
    }

    @Inject(method={"drawWaypointSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch()V")}, remap=true)
    public void drawWaypointDistances(PoseStack guiGraphics, Waypoint w, int x, int y, CallbackInfo ci) {
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        if (Settings.REGISTRY.showWaypointDistances.get() && w != null) {
            Entity renderViewEntity = Minecraft.m_91087_().m_91288_();
            double playerX = renderViewEntity.m_20185_();
            double playerZ = renderViewEntity.m_20189_();
            double playerY = renderViewEntity.m_20186_();
            double dimensionDivision = GuiWaypoints.distanceDivided;
            int wpX = w.getX(dimensionDivision);
            int wpY = w.getY();
            int wpZ = w.getZ(dimensionDivision);
            double distance = Math.sqrt(Math.pow(playerX - (double)wpX, 2.0) + Math.pow(playerY - (double)wpY, 2.0) + Math.pow(playerZ - (double)wpZ, 2.0));
            String text = NumberFormat.getIntegerInstance().format(distance) + "m";
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            GuiComponent.m_93236_((PoseStack)guiGraphics, (Font)fontRenderer, (String)text, (int)(x + 250), (int)(y + 1), (int)0xFFFFFF);
        }
    }
}

