/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalLongRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.biome.BlockTintProvider;
import xaero.map.region.MapRegion;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;
import xaero.map.world.MapWorld;
import xaeroplus.feature.extensions.CustomMapProcessor;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.caffeine.cache.Cache;
import xaeroplus.shadow.caffeine.cache.Caffeine;
import xaeroplus.util.ChunkUtils;

@Mixin(value={MapWriter.class}, remap=false)
public abstract class MixinMapWriter {
    @Unique
    private final Cache<Long, Long> xaeroPlus$tileUpdateCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.SECONDS).build();
    @Shadow
    private MapProcessor mapProcessor;
    @Shadow
    @Final
    private BlockPos.MutableBlockPos mutableLocalPos;
    @Shadow
    public long writeFreeSinceLastWrite;

    @Inject(method={"loadPixel"}, at={@At(value="HEAD")}, remap=false)
    public void setObsidianColumnLocalVar(CallbackInfo ci, @Share(value="columnRoofObsidian") LocalBooleanRef columnRoofObsidianRef) {
        if (!Settings.REGISTRY.transparentObsidianRoofSetting.get()) {
            return;
        }
        columnRoofObsidianRef.set(false);
    }

    @Inject(method={"loadPixel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFluidState()Lnet/minecraft/world/level/material/FluidState;", ordinal=0)}, remap=true)
    public void obsidianRoofHeadInject(CallbackInfo ci, @Local(argsOnly=true) LevelChunk bchunk, @Local(name={"state"}) LocalRef<BlockState> stateRef, @Local(name={"h"}) LocalIntRef hRef, @Local(name={"transparentSkipY"}) LocalIntRef transparentSkipYRef, @Share(value="columnRoofObsidian") LocalBooleanRef columnRoofObsidianRef) {
        boolean blockHeightAboveYLimit;
        if (!Settings.REGISTRY.transparentObsidianRoofSetting.get()) {
            return;
        }
        Block b = ((BlockState)stateRef.get()).m_60734_();
        boolean bl = blockHeightAboveYLimit = (double)hRef.get() >= Settings.REGISTRY.transparentObsidianRoofYSetting.get();
        if (blockHeightAboveYLimit) {
            boolean shouldMakeTransparent;
            boolean bl2 = shouldMakeTransparent = b == Blocks.f_50080_ || b == Blocks.f_50723_;
            if (b == Blocks.f_50125_) {
                this.mutableLocalPos.m_142448_(hRef.get() - 1);
                BlockState belowState = bchunk.m_8055_((BlockPos)this.mutableLocalPos);
                this.mutableLocalPos.m_142448_(hRef.get());
                boolean bl3 = shouldMakeTransparent = belowState.m_60734_() == Blocks.f_50080_ || belowState.m_60734_() == Blocks.f_50723_;
            }
            if (shouldMakeTransparent) {
                if (Settings.REGISTRY.transparentObsidianRoofDarkeningSetting.get() == 0.0) {
                    stateRef.set((Object)Blocks.f_50016_.m_49966_());
                    transparentSkipYRef.set(transparentSkipYRef.get() - 1);
                }
                if (!columnRoofObsidianRef.get()) {
                    columnRoofObsidianRef.set(true);
                }
            }
        }
    }

    @WrapOperation(method={"loadPixel"}, at={@At(value="INVOKE", target="Lxaero/map/region/OverlayBuilder;isEmpty()Z")}, remap=false)
    public boolean checkObsidianRoofColumn(OverlayBuilder instance, Operation<Boolean> original, @Share(value="columnRoofObsidian") LocalBooleanRef columnRoofObsidianRef) {
        if (!Settings.REGISTRY.transparentObsidianRoofSetting.get()) {
            return (Boolean)original.call(new Object[]{instance});
        }
        return (Boolean)original.call(new Object[]{instance}) != false || columnRoofObsidianRef.get();
    }

    @ModifyExpressionValue(method={"loadPixelHelp"}, at={@At(value="INVOKE", target="Lxaero/map/MapWriter;shouldOverlayCached(Lnet/minecraft/world/level/block/state/StateHolder;)Z", ordinal=0)}, remap=false)
    public boolean obsidianRoofOverlayMod(boolean original, @Local(argsOnly=true) LevelChunk bChunk, @Local(name={"b"}) Block b, @Local(name={"h"}) int h) {
        if (Settings.REGISTRY.transparentObsidianRoofSetting.get() && (double)h > Settings.REGISTRY.transparentObsidianRoofYSetting.get()) {
            if (b == Blocks.f_50080_ || b == Blocks.f_50723_) {
                return true;
            }
            if (b == Blocks.f_50125_) {
                this.mutableLocalPos.m_142448_(h - 1);
                BlockState belowState = bChunk.m_8055_((BlockPos)this.mutableLocalPos);
                this.mutableLocalPos.m_142448_(h);
                return belowState.m_60734_() == Blocks.f_50080_ || belowState.m_60734_() == Blocks.f_50723_;
            }
        }
        return original;
    }

    @WrapOperation(method={"loadPixelHelp"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getLightBlock(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)I", ordinal=1)}, remap=true)
    public int getOpacityForObsidianRoof(BlockState instance, BlockGetter world, BlockPos pos, Operation<Integer> original, @Local(name={"h"}) int h) {
        if (Settings.REGISTRY.transparentObsidianRoofSetting.get() && (double)h > Settings.REGISTRY.transparentObsidianRoofYSetting.get()) {
            boolean shouldMakeTransparent;
            boolean bl = shouldMakeTransparent = instance.m_60734_() == Blocks.f_50080_ || instance.m_60734_() == Blocks.f_50723_;
            if (instance.m_60734_() == Blocks.f_50125_) {
                this.mutableLocalPos.m_142448_(h - 1);
                BlockState belowState = world.m_8055_((BlockPos)this.mutableLocalPos);
                this.mutableLocalPos.m_142448_(h);
                if (belowState.m_60734_() == Blocks.f_50080_ || belowState.m_60734_() == Blocks.f_50723_) {
                    shouldMakeTransparent = true;
                }
            }
            if (shouldMakeTransparent) {
                return 5;
            }
        }
        return (Integer)original.call(new Object[]{instance, world, pos});
    }

    @Inject(method={"onRender"}, at={@At(value="FIELD", target="Lxaero/map/MapWriter;lastWrite:J", opcode=180, ordinal=2)})
    public void fastMapMaxTilesPerCycleSetting(CallbackInfo ci, @Local(name={"tilesToUpdate"}) LocalLongRef tilesToUpdateRef, @Local(name={"sizeTiles"}) int sizeTiles) {
        if (Settings.REGISTRY.fastMapSetting.get()) {
            this.writeFreeSinceLastWrite = Math.max(1L, this.writeFreeSinceLastWrite);
            if (this.mapProcessor.getCurrentCaveLayer() == Integer.MAX_VALUE) {
                tilesToUpdateRef.set((long)Math.min((double)sizeTiles, Settings.REGISTRY.fastMapMaxTilesPerCycle.get()));
            }
        }
    }

    @ModifyExpressionValue(method={"onRender"}, at={@At(value="INVOKE", target="Ljava/lang/System;nanoTime()J", ordinal=2)})
    public long removeWriteTimeLimiterPerFrame(long original) {
        if (Settings.REGISTRY.fastMapSetting.get() && this.mapProcessor.getCurrentCaveLayer() == Integer.MAX_VALUE) {
            return 0L;
        }
        return original;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WrapOperation(method={"writeMap"}, at={@At(value="INVOKE", target="Lxaero/map/MapWriter;writeChunk(Lnet/minecraft/world/level/Level;IZLnet/minecraft/core/Registry;Lxaero/map/region/OverlayManager;ZZZZZLnet/minecraft/core/BlockPos$MutableBlockPos;Lxaero/map/biome/BlockTintProvider;IIIIIIIII)Z")}, remap=false)
    public boolean fastMap(MapWriter instance, Level world, int distance, boolean onlyLoad, Registry<Biome> biomeRegistry, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.MutableBlockPos mutableBlockPos3, BlockTintProvider blockTintProvider, int caveDepth, int caveStart, int layerToWrite, int tileChunkX, int tileChunkZ, int tileChunkLocalX, int tileChunkLocalZ, int chunkX, int chunkZ, Operation<Boolean> original) {
        if (!Settings.REGISTRY.fastMapSetting.get() || this.mapProcessor.getCurrentCaveLayer() != Integer.MAX_VALUE) return (Boolean)original.call(new Object[]{instance, world, distance, onlyLoad, biomeRegistry, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider, caveDepth, caveStart, layerToWrite, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ});
        Long cacheable = ChunkUtils.chunkPosToLong(chunkX, chunkZ);
        Long cacheValue = this.xaeroPlus$tileUpdateCache.getIfPresent(cacheable);
        if (Objects.nonNull(cacheValue)) {
            if (cacheValue >= System.currentTimeMillis() - (long)Settings.REGISTRY.fastMapWriterDelaySetting.get()) return false;
            this.xaeroPlus$tileUpdateCache.put(cacheable, System.currentTimeMillis());
            return (Boolean)original.call(new Object[]{instance, world, distance, onlyLoad, biomeRegistry, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider, caveDepth, caveStart, layerToWrite, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ});
        } else {
            this.xaeroPlus$tileUpdateCache.put(cacheable, System.currentTimeMillis());
        }
        return (Boolean)original.call(new Object[]{instance, world, distance, onlyLoad, biomeRegistry, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider, caveDepth, caveStart, layerToWrite, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ});
    }

    @Inject(method={"loadPixel"}, at={@At(value="HEAD")}, remap=false)
    public void netherCaveFixInject(CallbackInfo ci, @Local(argsOnly=true) Level world, @Local(index=9, argsOnly=true) LocalBooleanRef caveRef, @Local(index=10, argsOnly=true) LocalBooleanRef fullCaveRef) {
        if (Settings.REGISTRY.netherCaveFix.get()) {
            boolean nether = world.m_46472_() == Level.f_46429_;
            boolean shouldForceFullInNether = !caveRef.get() && nether;
            caveRef.set(shouldForceFullInNether || caveRef.get());
            fullCaveRef.set(shouldForceFullInNether || fullCaveRef.get());
        }
    }

    @WrapOperation(method={"onRender"}, at={@At(value="INVOKE", target="Lxaero/map/world/MapWorld;getCurrentDimensionId()Lnet/minecraft/resources/ResourceKey;")}, remap=false)
    public ResourceKey<Level> removeCustomDimSwitchWriterPrevention(MapWorld mapWorld, Operation<ResourceKey<Level>> original) {
        ClientLevel world = this.mapProcessor.getWorld();
        return Settings.REGISTRY.writesWhileDimSwitched.get() && world != null && mapWorld.isMultiplayer() ? world.m_46472_() : (ResourceKey)original.call(new Object[]{mapWorld});
    }

    @Inject(method={"onRender"}, at={@At(value="HEAD")})
    public void setCrossDimWriteSignals(CallbackInfo ci) {
        boolean signal = Settings.REGISTRY.writesWhileDimSwitched.get() && this.mapProcessor.getWorld() != null && this.mapProcessor.getMapWorld().isMultiplayer();
        ((CustomMapProcessor)this.mapProcessor).xaeroPlus$getLeafRegionActualDimSignal().set(signal);
        ((CustomMapProcessor)this.mapProcessor).xaeroPlus$getCurrentDimensionActualDimSignal().set(signal);
    }

    @Inject(method={"onRender"}, at={@At(value="RETURN")})
    public void resetSignals(CallbackInfo ci) {
        ((CustomMapProcessor)this.mapProcessor).xaeroPlus$getLeafRegionActualDimSignal().set(false);
        ((CustomMapProcessor)this.mapProcessor).xaeroPlus$getCurrentDimensionActualDimSignal().set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"onRender"}, at={@At(value="INVOKE", target="Lxaero/map/MapProcessor;getLeafMapRegion(IIIZ)Lxaero/map/region/MapRegion;")})
    public MapRegion getActualMapRegionInOnRender(MapProcessor mapProcessor, int caveLayer, int regX, int regZ, boolean create, Operation<MapRegion> original) {
        if (Settings.REGISTRY.writesWhileDimSwitched.get() && mapProcessor.getMapWorld().isMultiplayer()) {
            ((CustomMapProcessor)mapProcessor).xaeroPlus$getLeafRegionActualDimSignal().set(true);
        }
        try {
            MapRegion mapRegion = (MapRegion)original.call(new Object[]{mapProcessor, caveLayer, regX, regZ, create});
            return mapRegion;
        }
        finally {
            ((CustomMapProcessor)mapProcessor).xaeroPlus$getLeafRegionActualDimSignal().set(false);
        }
    }
}

