/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalXZ;
import baritone.api.utils.interfaces.IGoalRenderPos;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.misc.OptimizedMath;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.map.mods.SupportMods;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.feature.extensions.SyncedWaypoint;
import xaeroplus.module.Module;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.BaritoneGoalHelper;
import xaeroplus.util.BaritoneHelper;
import xaeroplus.util.ChunkUtils;

public class BaritoneGoalSync
extends Module {
    private static final WeakReference nullRef = new WeakReference<Object>(null);
    private WeakReference<Waypoint> baritoneWpRef = nullRef;
    private WeakReference<WaypointSet> baritoneWpSetRef = nullRef;
    private WeakReference<MinimapWorld> baritoneWpMinimapWorldRef = nullRef;
    private WeakReference<BlockPos> baritoneGoalPos = nullRef;
    private ResourceKey<Level> baritoneWpDimension = Level.f_46428_;

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        if (!BaritoneHelper.isBaritonePresent()) {
            return;
        }
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        MinimapWorld currentWorld = minimapSession.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return;
        }
        WaypointSet currentWpSet = currentWorld.getCurrentWaypointSet();
        if (currentWpSet == null) {
            return;
        }
        try {
            Goal goal = BaritoneGoalHelper.getBaritoneGoal();
            if (goal == null) {
                this.clearBaritoneWpAndState();
                return;
            }
            BlockPos baritoneGoalBlockPos = this.getBaritoneGoalBlockPos(goal);
            if (baritoneGoalBlockPos == null) {
                this.clearBaritoneWpAndState();
                return;
            }
            if (this.baritoneGoalPos.get() == null) {
                this.baritoneGoalPos = new WeakReference<BlockPos>(baritoneGoalBlockPos);
            }
            if (this.baritoneGoalPos.get() != null && !((BlockPos)this.baritoneGoalPos.get()).equals((Object)baritoneGoalBlockPos)) {
                this.clearBaritoneWpAndState();
                this.baritoneGoalPos = new WeakReference<BlockPos>(baritoneGoalBlockPos);
            }
            if (this.baritoneWpMinimapWorldRef.get() == null || currentWorld != this.baritoneWpMinimapWorldRef.get() || this.baritoneWpSetRef.get() == null || this.baritoneWpSetRef.get() != currentWpSet) {
                if (this.baritoneWpSetRef.get() != null && this.baritoneWpRef.get() != null) {
                    ((WaypointSet)this.baritoneWpSetRef.get()).remove((Waypoint)this.baritoneWpRef.get());
                }
                this.baritoneWpRef = nullRef;
                this.initBaritoneWpWorld(currentWorld);
            }
            double customDimDiv = this.getBaritoneWpDimDiv();
            int x = (int)((double)OptimizedMath.myFloor((double)baritoneGoalBlockPos.m_123341_()) * customDimDiv);
            int z = (int)((double)OptimizedMath.myFloor((double)baritoneGoalBlockPos.m_123343_()) * customDimDiv);
            Waypoint baritoneWp = (Waypoint)this.baritoneWpRef.get();
            if (baritoneWp != null) {
                if (baritoneWp.getX() != x || baritoneWp.getZ() != z) {
                    baritoneWp.setX(x);
                    baritoneWp.setY(baritoneGoalBlockPos.m_123342_());
                    baritoneWp.setZ(z);
                    SupportMods.xaeroMinimap.requestWaypointsRefresh();
                }
            } else {
                baritoneWp = SyncedWaypoint.create(x, baritoneGoalBlockPos.m_123342_(), z, "Baritone Goal", "B", WaypointColor.GREEN);
                this.baritoneWpRef = new WeakReference<Waypoint>(baritoneWp);
                ((WaypointSet)this.baritoneWpSetRef.get()).add(baritoneWp);
                SupportMods.xaeroMinimap.requestWaypointsRefresh();
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error in Baritone goal sync", (Throwable)e);
        }
    }

    private double getBaritoneWpDimDiv() {
        if (this.baritoneWpMinimapWorldRef.get() == null) {
            return 1.0;
        }
        ResourceKey baritoneWpMinimapWorldDimId = ((MinimapWorld)this.baritoneWpMinimapWorldRef.get()).getDimId();
        double customDimDiv = 1.0;
        if (baritoneWpMinimapWorldDimId != this.baritoneWpDimension) {
            if (baritoneWpMinimapWorldDimId == Level.f_46429_ && this.baritoneWpDimension == Level.f_46428_) {
                customDimDiv = 0.125;
            } else if (baritoneWpMinimapWorldDimId == Level.f_46428_ && this.baritoneWpDimension == Level.f_46429_) {
                customDimDiv = 8.0;
            }
        }
        return customDimDiv;
    }

    private void initBaritoneWpWorld(MinimapWorld currentWorld) {
        this.baritoneWpMinimapWorldRef = new WeakReference<MinimapWorld>(currentWorld);
        WaypointSet waypointSet = currentWorld.getCurrentWaypointSet();
        this.baritoneWpSetRef = new WeakReference<WaypointSet>(waypointSet);
    }

    private void clearBaritoneWpAndState() {
        if (this.baritoneWpRef.get() != null) {
            ((WaypointSet)this.baritoneWpSetRef.get()).remove((Waypoint)this.baritoneWpRef.get());
        }
        this.baritoneWpRef = nullRef;
        this.baritoneWpSetRef = nullRef;
        this.baritoneWpMinimapWorldRef = nullRef;
        this.baritoneGoalPos = nullRef;
        this.baritoneWpDimension = ChunkUtils.getActualDimension();
    }

    private BlockPos getBaritoneGoalBlockPos(Goal goal) {
        if (goal instanceof GoalXZ) {
            return new BlockPos(((GoalXZ)goal).getX(), 64, ((GoalXZ)goal).getZ());
        }
        if (goal instanceof IGoalRenderPos) {
            return ((IGoalRenderPos)goal).getGoalPos();
        }
        return null;
    }
}

