/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import xaeroplus.Globals;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.feature.highlights.SavableHighlightCacheInstance;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class OldChunks
extends Module {
    public final SavableHighlightCacheInstance oldChunksCache = new SavableHighlightCacheInstance("XaeroPlusOldChunks");
    public final SavableHighlightCacheInstance modernChunksCache = new SavableHighlightCacheInstance("XaeroPlusModernChunks");
    private int oldChunksColor = ColorHelper.getColor(0, 0, 255, 100);
    private boolean inverse = false;
    private static final ReferenceSet<Block> OVERWORLD_BLOCKS = ReferenceOpenHashSet.of((Object[])new Block[]{Blocks.f_152505_, Blocks.f_152506_, Blocks.f_152490_, Blocks.f_152597_, Blocks.f_152496_, Blocks.f_50575_, Blocks.f_50576_, Blocks.f_152588_, Blocks.f_152537_, Blocks.f_152550_, Blocks.f_152541_, Blocks.f_152545_, Blocks.f_152546_, Blocks.f_152547_, Blocks.f_152544_, Blocks.f_152538_, Blocks.f_152539_});
    private static final ReferenceSet<Block> NETHER_BLOCKS = ReferenceOpenHashSet.of((Object[])new Block[]{Blocks.f_50722_, Blocks.f_50730_, Blocks.f_50137_, Blocks.f_50699_, Blocks.f_50690_, Blocks.f_49998_, Blocks.f_50184_});

    public void setDiskCache(boolean disk) {
        this.oldChunksCache.setDiskCache(disk, this.isEnabled());
        this.modernChunksCache.setDiskCache(disk, this.isEnabled());
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        if (event.seenChunk()) {
            return;
        }
        this.searchChunk((ChunkAccess)event.chunk());
    }

    private void searchChunk(ChunkAccess chunk) {
        ResourceKey<Level> actualDimension = ChunkUtils.getActualDimension();
        int x = chunk.m_7697_().f_45578_;
        int z = chunk.m_7697_().f_45579_;
        if (this.modernChunksCache.get().isHighlighted(x, z, actualDimension)) {
            return;
        }
        if (this.oldChunksCache.get().isHighlighted(x, z, actualDimension)) {
            return;
        }
        if (actualDimension == Level.f_46428_ || actualDimension == Level.f_46429_) {
            if (ChunkScanner.chunkContainsBlocks(chunk, actualDimension == Level.f_46428_ ? OVERWORLD_BLOCKS : NETHER_BLOCKS, 5)) {
                this.modernChunksCache.get().addHighlight(x, z);
            } else {
                this.oldChunksCache.get().addHighlight(x, z);
            }
        } else if (actualDimension == Level.f_46430_) {
            Holder biomeHolder = this.mc.f_91073_.m_204166_(new BlockPos(ChunkUtils.chunkCoordToCoord(x) + 8, 64, ChunkUtils.chunkCoordToCoord(z) + 8));
            if (biomeHolder.m_203543_().filter(biome -> biome.equals((Object)Biomes.f_48210_)).isEmpty()) {
                this.modernChunksCache.get().addHighlight(x, z);
            } else {
                this.oldChunksCache.get().addHighlight(x, z);
            }
        }
    }

    public boolean inUnknownDimension() {
        ResourceKey<Level> dim = ChunkUtils.getActualDimension();
        return dim != Level.f_46428_ && dim != Level.f_46429_ && dim != Level.f_46430_;
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().register(DrawFeatureFactory.chunkHighlights("OldChunks", this::getHighlightsState, this::getOldChunksColor, 250));
        this.oldChunksCache.onEnable();
        this.modernChunksCache.onEnable();
        this.searchAllLoadedChunks();
    }

    private void searchAllLoadedChunks() {
        if (this.mc.f_91073_ == null || this.inUnknownDimension()) {
            return;
        }
        int renderDist = (Integer)this.mc.f_91066_.m_231984_().m_231551_();
        int xMin = ChunkUtils.actualPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.actualPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.actualPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.actualPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                LevelChunk chunk = this.mc.f_91073_.m_7726_().m_62227_(x, z, false);
                if (chunk instanceof EmptyLevelChunk || chunk == null) continue;
                this.searchChunk((ChunkAccess)chunk);
            }
        }
    }

    @Override
    public void onDisable() {
        this.oldChunksCache.onDisable();
        this.modernChunksCache.onDisable();
        Globals.drawManager.registry().unregister("OldChunks");
    }

    public int getOldChunksColor() {
        return this.oldChunksColor;
    }

    public void setRgbColor(int color) {
        this.oldChunksColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.oldChunksAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.oldChunksColor = ColorHelper.getColorWithAlpha(this.oldChunksColor, (int)a);
    }

    public boolean isHighlighted(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.inverse ? this.isOldChunkInverse(chunkPosX, chunkPosZ, dimensionId) : this.isOldChunk(chunkPosX, chunkPosZ, dimensionId);
    }

    public Long2LongMap getHighlightsState(ResourceKey<Level> dimension) {
        return this.inverse ? this.modernChunksCache.get().getCacheMap(dimension) : this.oldChunksCache.get().getCacheMap(dimension);
    }

    public boolean isOldChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.oldChunksCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isOldChunkInverse(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.modernChunksCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public void setInverse(Boolean b) {
        this.inverse = b;
    }
}

