/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.BitStorage;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.feature.highlights.SavableHighlightCacheInstance;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class PaletteNewChunks
extends Module {
    public final SavableHighlightCacheInstance newChunksCache = new SavableHighlightCacheInstance("XaeroPlusPaletteNewChunks");
    public final SavableHighlightCacheInstance newChunksInverseCache = new SavableHighlightCacheInstance("XaeroPlusPaletteNewChunksInverse");
    private int newChunksColor = ColorHelper.getColor(255, 0, 0, 100);
    private final IntSet presentStateIdsBuf = new IntOpenHashSet();
    private final IntList presentStateIdsOrderedBuf = new IntArrayList();
    private boolean renderInverse = false;

    public void setDiskCache(boolean disk) {
        this.newChunksCache.setDiskCache(disk, this.isEnabled());
        this.newChunksInverseCache.setDiskCache(disk, this.isEnabled());
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        if (event.seenChunk()) {
            return;
        }
        ResourceKey<Level> dim = ChunkUtils.getActualDimension();
        LevelChunk chunk = event.chunk();
        int x = chunk.m_7697_().f_45578_;
        int z = chunk.m_7697_().f_45579_;
        try {
            if (this.newChunksCache.get().isHighlighted(x, z, dim)) {
                return;
            }
            if (this.newChunksInverseCache.get().isHighlighted(x, z, dim)) {
                return;
            }
            if (this.isNewChunk(dim, chunk)) {
                this.newChunksCache.get().addHighlight(x, z);
            } else {
                this.newChunksInverseCache.get().addHighlight(x, z);
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error checking palette NewChunk at [{} {}]", new Object[]{x, z, e});
        }
    }

    private boolean isNewChunk(ResourceKey<Level> dim, LevelChunk chunk) {
        if (dim == Level.f_46428_) {
            boolean bl;
            if (Settings.REGISTRY.paletteNewChunksVersionUpgradedChunks.get()) {
                bl = this.checkNewChunkBlockStatePalette(chunk);
            } else {
                switch (this.checkNewChunkBiomePalette(chunk, true).ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 0: {
                        bl = false;
                        break;
                    }
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = this.checkNewChunkBlockStatePalette(chunk);
                    }
                }
            }
            return bl;
        }
        if (dim == Level.f_46429_) {
            return Settings.REGISTRY.paletteNewChunksVersionUpgradedChunks.get() ? this.checkNewChunkBlockStatePalette(chunk) : this.checkNewChunkBiomePalette(chunk, false) == BiomeCheckResult.PLAINS_IN_PALETTE;
        }
        if (dim == Level.f_46430_) {
            return this.checkNewChunkBiomePalette(chunk, false) == BiomeCheckResult.PLAINS_IN_PALETTE;
        }
        return false;
    }

    private boolean checkNewChunkBlockStatePalette(LevelChunk chunk) {
        LevelChunkSection[] sections = chunk.m_7103_();
        if (sections.length == 0) {
            return false;
        }
        for (int i = 0; i < Math.min(sections.length, 12); ++i) {
            LevelChunkSection section = sections[i];
            PalettedContainer.Data paletteContainerData = section.m_63019_().f_188032_;
            Palette palette = paletteContainerData.f_188102_();
            if (palette.m_62680_() < 2) continue;
            if (palette instanceof LinearPalette) {
                return this.checkLinearPaletteOrder((Palette<BlockState>)palette, section);
            }
            if (!(palette instanceof HashMapPalette) || !this.checkForExtraPaletteEntries((PalettedContainer.Data<BlockState>)paletteContainerData)) continue;
            return true;
        }
        return false;
    }

    private boolean checkLinearPaletteOrder(Palette<BlockState> palette, LevelChunkSection section) {
        this.presentStateIdsOrderedBuf.clear();
        for (int id = 0; id < palette.m_62680_(); ++id) {
            int blockStateId = Block.m_49956_((BlockState)((BlockState)palette.m_5795_(id)));
            this.presentStateIdsOrderedBuf.add(blockStateId);
        }
        this.presentStateIdsBuf.clear();
        AtomicInteger searchIndex = new AtomicInteger(0);
        AtomicBoolean isNewChunk = new AtomicBoolean(false);
        section.m_63019_().f_188032_.f_188101_().m_13519_(dataId -> {
            if (isNewChunk.get()) {
                return;
            }
            if (searchIndex.get() == this.presentStateIdsOrderedBuf.size()) {
                return;
            }
            int blockStateId = Block.m_49956_((BlockState)((BlockState)palette.m_5795_(dataId)));
            if (this.presentStateIdsBuf.contains(blockStateId)) {
                return;
            }
            int nextExpectedId = this.presentStateIdsOrderedBuf.getInt(searchIndex.get());
            if (blockStateId == nextExpectedId) {
                this.presentStateIdsBuf.add(blockStateId);
                searchIndex.incrementAndGet();
            } else {
                isNewChunk.set(true);
            }
        });
        return isNewChunk.get();
    }

    private BiomeCheckResult checkNewChunkBiomePalette(LevelChunk chunk, boolean checkData) {
        LevelChunkSection[] sections = chunk.m_7103_();
        if (sections.length == 0) {
            return BiomeCheckResult.NO_PLAINS;
        }
        LevelChunkSection firstSection = sections[0];
        PalettedContainerRO biomes = firstSection.m_187996_();
        if (biomes instanceof PalettedContainer) {
            PalettedContainer biomesPaletteContainer = (PalettedContainer)biomes;
            Palette palette = biomesPaletteContainer.f_188032_.f_188102_();
            boolean paletteContainsPlains = palette.m_6419_(PaletteNewChunks::isPlainsBiome);
            if (paletteContainsPlains && checkData) {
                if (palette.m_62680_() == 1) {
                    return BiomeCheckResult.PLAINS_PRESENT;
                }
                BitStorage storage = biomesPaletteContainer.f_188032_.f_188101_();
                this.presentStateIdsBuf.clear();
                storage.m_13519_(arg_0 -> ((IntSet)this.presentStateIdsBuf).add(arg_0));
                IntIterator intIterator = this.presentStateIdsBuf.iterator();
                while (intIterator.hasNext()) {
                    int id = (Integer)intIterator.next();
                    if (!PaletteNewChunks.isPlainsBiome((Holder<Biome>)((Holder)palette.m_5795_(id)))) continue;
                    return BiomeCheckResult.PLAINS_PRESENT;
                }
            }
            if (paletteContainsPlains) {
                return BiomeCheckResult.PLAINS_IN_PALETTE;
            }
        }
        return BiomeCheckResult.NO_PLAINS;
    }

    private synchronized boolean checkForExtraPaletteEntries(PalettedContainer.Data<BlockState> paletteContainer) {
        this.presentStateIdsBuf.clear();
        Palette palette = paletteContainer.f_188102_();
        BitStorage storage = paletteContainer.f_188101_();
        storage.m_13519_(arg_0 -> ((IntSet)this.presentStateIdsBuf).add(arg_0));
        return palette.m_62680_() > this.presentStateIdsBuf.size();
    }

    private static boolean isPlainsBiome(Holder<Biome> holder) {
        return holder.m_203565_(Biomes.f_48202_);
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().register(DrawFeatureFactory.chunkHighlights("PaletteNewChunks", this::getHighlightsState, this::getNewChunksColor, 250));
        this.newChunksCache.onEnable();
        this.newChunksInverseCache.onEnable();
    }

    @Override
    public void onDisable() {
        this.newChunksCache.onDisable();
        this.newChunksInverseCache.onDisable();
        Globals.drawManager.registry().unregister("PaletteNewChunks");
    }

    public int getNewChunksColor() {
        return this.newChunksColor;
    }

    public void setRgbColor(int color) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.paletteNewChunksAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(this.newChunksColor, (int)a);
    }

    public void setInverse(boolean b) {
        this.renderInverse = b;
    }

    public boolean isHighlighted(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.renderInverse ? this.isInverseNewChunk(chunkPosX, chunkPosZ, dimensionId) : this.isNewChunk(chunkPosX, chunkPosZ, dimensionId);
    }

    public Long2LongMap getHighlightsState(ResourceKey<Level> dimension) {
        return this.renderInverse ? this.newChunksInverseCache.get().getCacheMap(dimension) : this.newChunksCache.get().getCacheMap(dimension);
    }

    public boolean isNewChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.newChunksCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isInverseNewChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.newChunksInverseCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    static enum BiomeCheckResult {
        NO_PLAINS,
        PLAINS_IN_PALETTE,
        PLAINS_PRESENT;

    }
}

