/*
 * Decompiled with CFR 0.152.
 */
package com.capemod.pterocontrol.velocity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PteroAPI {
    private final String apiUrl;
    private final String apiKey;
    private final HttpClient httpClient;
    private final Gson gson = new GsonBuilder().create();

    public PteroAPI(String apiUrl, String apiKey) {
        this.apiUrl = apiUrl.endsWith("/") ? apiUrl : apiUrl + "/";
        this.apiKey = apiKey;
        this.httpClient = HttpClient.newHttpClient();
    }

    public Map<String, String> getServers() {
        try {
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.apiUrl + "api/client")).header("Authorization", "Bearer " + this.apiKey).header("Accept", "application/json").build();
            HttpResponse<String> res = this.httpClient.send(req, HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() != 200) {
                return Collections.emptyMap();
            }
            JsonObject json = (JsonObject)this.gson.fromJson(res.body(), JsonObject.class);
            HashMap<String, String> map = new HashMap<String, String>();
            for (JsonElement e : json.getAsJsonArray("data")) {
                JsonObject obj = e.getAsJsonObject().getAsJsonObject("attributes");
                String identifier = obj.get("identifier").getAsString();
                String name = obj.get("name").getAsString();
                map.put(name.toLowerCase(), identifier);
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
    }

    public boolean powerAction(String identifier, String action) {
        try {
            JsonObject body = new JsonObject();
            body.addProperty("signal", action);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.apiUrl + "api/client/servers/" + identifier + "/power")).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.apiKey).POST(HttpRequest.BodyPublishers.ofString(body.toString())).build();
            HttpResponse<String> res = this.httpClient.send(req, HttpResponse.BodyHandlers.ofString());
            return res.statusCode() == 204;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean runCommand(String serverId, String command) {
        try {
            URL url = new URL(this.apiUrl + "api/client/servers/" + serverId + "/command");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Authorization", "Bearer " + this.apiKey);
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            String json = "{\"command\":\"" + command.replace("\"", "\\\"") + "\"}";
            try (OutputStream os = con.getOutputStream();){
                os.write(json.getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = con.getResponseCode();
            if (responseCode == 204 || responseCode == 200) {
                return true;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getErrorStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    System.err.println(line);
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

