/*
 * Decompiled with CFR 0.152.
 */
package com.capemod.pterocontrol.velocity;

import com.capemod.pterocontrol.velocity.PteroAPI;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;

@Plugin(id="pterocontrol", name="PteroControl", version="1.0.0")
public class VelocityPteroPlugin {
    private final ProxyServer server;
    private final Logger logger;
    private PteroAPI client;
    private Map<String, String> servers = new HashMap<String, String>();
    private boolean aliasesEnabled = true;

    @Inject
    public VelocityPteroPlugin(ProxyServer server, Logger logger) {
        this.server = server;
        this.logger = logger;
    }

    @Subscribe
    public void onInit(ProxyInitializeEvent e) {
        this.loadConfig();
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("pc").build(), (Command)new PteroCommand());
        if (this.aliasesEnabled) {
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("startserver").build(), (Command)new AliasCommand("start"));
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("stopserver").build(), (Command)new AliasCommand("stop"));
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("restartserver").build(), (Command)new AliasCommand("restart"));
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("runcmd").build(), (Command)new AliasCommand("runcmd"));
        }
        this.logger.info("PteroControl started.");
    }

    private void loadConfig() {
        try {
            Path f = Paths.get("plugins/PteroControl/config.json", new String[0]);
            if (!Files.exists(f, new LinkOption[0])) {
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
                JsonObject c = new JsonObject();
                c.addProperty("api_url", "https://panel.example.com/");
                c.addProperty("api_key", "USER-API-KEY-HERE");
                c.addProperty("aliases", Boolean.valueOf(true));
                Files.writeString(f, (CharSequence)new Gson().toJson((JsonElement)c), new OpenOption[0]);
            }
            JsonObject conf = (JsonObject)new Gson().fromJson(Files.readString(f), JsonObject.class);
            this.client = new PteroAPI(conf.get("api_url").getAsString(), conf.get("api_key").getAsString());
            this.aliasesEnabled = conf.get("aliases").getAsBoolean();
            this.servers = this.client.getServers();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class PteroCommand
    implements SimpleCommand {
        private PteroCommand() {
        }

        public void execute(SimpleCommand.Invocation inv) {
            String[] a = (String[])inv.arguments();
            if (a.length < 2) {
                inv.source().sendMessage((Component)Component.text((String)"\u00a7cUsage: /pc <start|stop|restart|runcmd> <server>"));
                return;
            }
            String action = a[0].toLowerCase();
            if (action.equals("runcmd") && !inv.source().hasPermission("pterocontrol.runcmd")) {
                inv.source().sendMessage((Component)Component.text((String)"\u00a7cYou don't have permission to run commands."));
                return;
            }
            if ((action.equals("start") || action.equals("stop") || action.equals("restart")) && !inv.source().hasPermission("pterocontrol.power")) {
                inv.source().sendMessage((Component)Component.text((String)"\u00a7cYou don't have permission to control servers."));
                return;
            }
            if (action.equals("runcmd")) {
                if (a.length < 3) {
                    inv.source().sendMessage((Component)Component.text((String)"\u00a7cUsage: /pc runcmd <server> <command>"));
                    return;
                }
                String name = null;
                String cmd = null;
                for (int i = 2; i <= a.length; ++i) {
                    String possibleName = String.join((CharSequence)" ", Arrays.copyOfRange(a, 1, i)).toLowerCase();
                    if (!VelocityPteroPlugin.this.servers.containsKey(possibleName)) continue;
                    name = possibleName;
                    cmd = String.join((CharSequence)" ", Arrays.copyOfRange(a, i, a.length));
                    break;
                }
                if (name == null) {
                    inv.source().sendMessage((Component)Component.text((String)"\u00a7cServer not found."));
                    return;
                }
                boolean ok = VelocityPteroPlugin.this.client.runCommand(VelocityPteroPlugin.this.servers.get(name), cmd);
                inv.source().sendMessage((Component)Component.text((String)(ok ? "\u00a7aCommand executed." : "\u00a7cFailed")));
                return;
            }
            String name = null;
            for (int i = 1; i <= a.length; ++i) {
                String possibleName = String.join((CharSequence)" ", Arrays.copyOfRange(a, 1, i)).toLowerCase();
                if (!VelocityPteroPlugin.this.servers.containsKey(possibleName)) continue;
                name = possibleName;
                break;
            }
            if (name == null) {
                inv.source().sendMessage((Component)Component.text((String)"\u00a7cServer not found."));
                return;
            }
            boolean ok = VelocityPteroPlugin.this.client.powerAction(VelocityPteroPlugin.this.servers.get(name), action);
            inv.source().sendMessage((Component)Component.text((String)(ok ? "\u00a7aAction successful." : "\u00a7cFailed")));
        }

        public List<String> suggest(SimpleCommand.Invocation inv) {
            ArrayList<String> out = new ArrayList<String>();
            if (((String[])inv.arguments()).length == 0) {
                return List.of("start", "stop", "restart", "runcmd");
            }
            if (((String[])inv.arguments()).length == 1) {
                return List.of("start", "stop", "restart", "runcmd");
            }
            if (((String[])inv.arguments()).length == 2) {
                return new ArrayList<String>(VelocityPteroPlugin.this.servers.keySet());
            }
            if (((String[])inv.arguments()).length >= 3 && ((String[])inv.arguments())[0].equalsIgnoreCase("runcmd")) {
                return List.of("<command>");
            }
            return out;
        }
    }

    private class AliasCommand
    implements SimpleCommand {
        private final String action;

        public AliasCommand(String action) {
            this.action = action;
        }

        public void execute(SimpleCommand.Invocation inv) {
            String[] a = (String[])inv.arguments();
            if (a.length == 0) {
                inv.source().sendMessage((Component)Component.text((String)("\u00a7cUsage: /" + this.action + " <server>")));
                return;
            }
            if (this.action.equals("runcmd") && !inv.source().hasPermission("pterocontrol.runcmd")) {
                inv.source().sendMessage((Component)Component.text((String)"\u00a7cYou don't have permission to run commands."));
                return;
            }
            if ((this.action.equals("start") || this.action.equals("stop") || this.action.equals("restart")) && !inv.source().hasPermission("pterocontrol.power")) {
                inv.source().sendMessage((Component)Component.text((String)"\u00a7cYou don't have permission to control servers."));
                return;
            }
            if (this.action.equals("runcmd")) {
                if (a.length < 2) {
                    inv.source().sendMessage((Component)Component.text((String)"\u00a7cUsage: /runcmd <server> <command>"));
                    return;
                }
                String name = null;
                String cmd = null;
                for (int i = 1; i <= a.length; ++i) {
                    String possibleName = String.join((CharSequence)" ", Arrays.copyOfRange(a, 0, i)).toLowerCase();
                    if (!VelocityPteroPlugin.this.servers.containsKey(possibleName)) continue;
                    name = possibleName;
                    cmd = String.join((CharSequence)" ", Arrays.copyOfRange(a, i, a.length));
                    break;
                }
                if (name == null) {
                    inv.source().sendMessage((Component)Component.text((String)"\u00a7cServer not found."));
                    return;
                }
                boolean ok = VelocityPteroPlugin.this.client.runCommand(VelocityPteroPlugin.this.servers.get(name), cmd);
                inv.source().sendMessage((Component)Component.text((String)(ok ? "\u00a7aCommand executed." : "\u00a7cFailed")));
                return;
            }
            String name = null;
            for (int i = 0; i < a.length; ++i) {
                String possibleName = String.join((CharSequence)" ", Arrays.copyOfRange(a, 0, i + 1)).toLowerCase();
                if (!VelocityPteroPlugin.this.servers.containsKey(possibleName)) continue;
                name = possibleName;
                break;
            }
            if (name == null) {
                inv.source().sendMessage((Component)Component.text((String)"\u00a7cServer not found."));
                return;
            }
            boolean ok = VelocityPteroPlugin.this.client.powerAction(VelocityPteroPlugin.this.servers.get(name), this.action);
            inv.source().sendMessage((Component)Component.text((String)(ok ? "\u00a7aAction successful." : "\u00a7cFailed")));
        }

        public List<String> suggest(SimpleCommand.Invocation inv) {
            return new ArrayList<String>(VelocityPteroPlugin.this.servers.keySet());
        }
    }
}

