/*
 * This file is part of tnoctua's FabricMC Name Changer mod
 * Please read the full license terms at (https://github.com/tnoctua/name-changer)
 * Copyright (C) 2025	tnoctua
 */

package me.tnoctua.namechanger.mixin;

import com.mojang.authlib.GameProfile;
import me.tnoctua.namechanger.NameChanger;
import net.minecraft.class_2561;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static me.tnoctua.namechanger.NameChanger.client;

@Mixin(class_640.class)
public abstract class PlayerListEntryMixin {

    @Shadow @Final private GameProfile profile;

    @Inject(method = "getDisplayName", at = @At("HEAD"), cancellable = true)
    private void getDisplayName(CallbackInfoReturnable<class_2561> cir) {
        if (client.field_1724 != null && profile.getId().equals(client.field_1724.method_5667())) {
            cir.setReturnValue(class_2561.method_43470(NameChanger.getName()));
        }
    }

}
