/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_chicken.compat.jei;

import com.oierbravo.create_mechanical_chicken.CreateMechanicalChicken;
import com.oierbravo.create_mechanical_chicken.ModLang;
import com.oierbravo.create_mechanical_chicken.ModRegistration;
import com.oierbravo.create_mechanical_chicken.compat.jei.AnimatedChicken;
import com.oierbravo.create_mechanical_chicken.infrastructure.config.MConfigs;
import com.oierbravo.mechanicals.utility.MechanicalConfigUtils;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public class MechanicalChickenCategory
implements IRecipeCategory<MechanicalChickenRecipe> {
    public static final RecipeType<MechanicalChickenRecipe> TYPE = RecipeType.create((String)"create_mechanical_chicken", (String)"production", MechanicalChickenRecipe.class);
    private final IDrawable icon;
    private final IDrawable slotDrawable;
    private AnimatedChicken chicken = new AnimatedChicken();

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 40;
    }

    public MechanicalChickenCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModRegistration.MECHANICAL_CHICKEN_BLOCK));
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public RecipeType<MechanicalChickenRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return ModLang.translate("recipe", new Object[0]).component();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MechanicalChickenRecipe recipe, IFocusGroup iFocusGroup) {
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 4, 15).setBackground(this.slotDrawable, -1, -1);
        if (recipe.fluid != null) {
            ((IRecipeSlotBuilder)input.addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipe.fluid().getFluids()))).addRichTooltipCallback(MechanicalChickenCategory::addFluidAmountTooltip);
        }
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 155, 15);
        if (recipe.itemStack != null) {
            ((IRecipeSlotBuilder)output.addItemStack(recipe.itemStack)).setBackground(this.slotDrawable, -1, -1);
        }
    }

    private static void addFluidAmountTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
        Optional displayed = recipeSlotView.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK);
        if (displayed.isEmpty()) {
            return;
        }
        FluidStack fluidStack = (FluidStack)displayed.get();
        tooltip.add((FormattedText)Component.literal((String)(fluidStack.getAmount() + "mB")));
    }

    public void draw(MechanicalChickenRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        AllGuiTextures.JEI_ARROW.render(guiGraphics, 30, 16);
        AllGuiTextures.JEI_ARROW.render(guiGraphics, 110, 16);
        this.chicken.draw(guiGraphics, 82, 35);
    }

    private static SizedFluidIngredient getFluidIngredientFromConfig() {
        SizedFluidIngredient fluidIngredient = SizedFluidIngredient.of((FluidStack)FluidStack.EMPTY);
        String fluidResourceRaw = (String)MConfigs.server().mechanicalChicken.requiredFluid.get();
        int configuredAmount = (Integer)MConfigs.server().mechanicalChicken.requiredFluidAmount.get();
        if (fluidResourceRaw.startsWith("#")) {
            ResourceLocation fluidTag = ResourceLocation.tryParse((String)fluidResourceRaw.replace("#", ""));
            assert (fluidTag != null);
            return SizedFluidIngredient.of((TagKey)FluidTags.create((ResourceLocation)fluidTag), (int)configuredAmount);
        }
        ResourceLocation desiredFluid = ResourceLocation.parse((String)fluidResourceRaw);
        if (BuiltInRegistries.FLUID.containsKey(desiredFluid)) {
            fluidIngredient = SizedFluidIngredient.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(desiredFluid)), (int)configuredAmount);
        } else {
            CreateMechanicalChicken.LOGGER.error("Unknown fluid '{}' in config, using default '{}' instead", (Object)fluidResourceRaw, (Object)"minecraft:water");
            fluidIngredient = SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)configuredAmount);
        }
        return fluidIngredient;
    }

    public static List<MechanicalChickenRecipe> getRecipes() {
        ArrayList<MechanicalChickenRecipe> recipes = new ArrayList<MechanicalChickenRecipe>();
        int configuredOutputAmount = (Integer)MConfigs.server().mechanicalChicken.outputAmount.get();
        recipes.add(new MechanicalChickenRecipe(SizedFluidIngredient.of((FluidStack)MechanicalConfigUtils.readFluidStack((String)((String)MConfigs.server().mechanicalChicken.requiredFluid.get()), (int)((Integer)MConfigs.server().mechanicalChicken.requiredFluidAmount.get()), (String)"minecraft:water")), new ItemStack((ItemLike)Items.EGG, configuredOutputAmount)));
        return recipes;
    }

    public record MechanicalChickenRecipe(@Nullable SizedFluidIngredient fluid, ItemStack itemStack) {
    }
}

