StartupEvents.registry('palladium:abilities', (event) => {
    event.create('darkside:darkness_immunity')
        .icon(palladium.createItemIcon('minecraft:diamond'))
        .addProperty("effect", "string", "minecraft:darkness", "minecraft:darkness")
        .addProperty("command", "string", "", "effect clear @s minecraft:darkness")
        .tick((entity, entry, holder, enabled) => {
            const command = entry.getPropertyByName("command")
            const effect = entry.getPropertyByName("effect")
            if (enabled) {
                if(entity.hasEffect(effect)) {
                    entity.removeEffect(effect)
                    entity.runCommandSilent(command)
                }
            }
        });
});