PalladiumEvents.registerAnimations((event) => {
    event.register('virinite/aim', 200, (builder) => {
        let animation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'darkside_aliens:virinite', 'punch_righthand', builder.getPartialTicks());

        if (animation > 0) {
            if (!builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setZ(4)
                    .setXRotDegrees(-100)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('easeOutCubic', animation);

                builder.get('left_arm')
                    .setXRotDegrees(-26)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(5)
                    .animate('easeOutCubic', animation);

                builder.get('body')
                    .rotateYDegrees(-45)
                    .animate('easeOutCubic', animation);

                builder.get('head')
                    .rotateYDegrees(-45)
                    .animate('easeOutCubic', animation);
            }

            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setY(-10)
                    .animate('easeOutCubic', animation);
            }
        }
        
if (abilityUtil.isEnabled(builder.getPlayer(), "darkside_aliens:virinite", "ruthless_blow")) {
            let animation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'darkside_aliens:virinite', 'ruthless_blow', builder.getPartialTicks());
            if (animation > 0) {
                if (!builder.isFirstPerson()) {
                    builder.get('right_arm')
                        .setXRotDegrees(-26)
                        .setYRotDegrees(5)
                        .setZRotDegrees(-5)
                        .animate('easeOutCubic', animation);

                    builder.get('left_arm')
                        .setXRotDegrees(-100)
                        .setZ(4)
                        .animate('easeOutCubic', animation);

                    builder.get('body')
                        .rotateYDegrees(45)
                        .animate('easeOutCubic', animation);

                    builder.get('head')
                        .rotateYDegrees(45)
                        .animate('easeOutCubic', animation);
                }

                if (builder.isFirstPerson()) {
                    builder.get('left_arm')
                        .setY(-10)
                        .animate('easeOutCubic', animation);
                }
        }}

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('darkside/virinitecharge_leap', 200, (builder) => {
        let charge_leap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'darkside_aliens:virinite', 'leap_charge', builder.getPartialTicks());
        if (!palladium.abilities.isEnabled(builder.getPlayer(), 'darkside_aliens:virinite', 'leap_charge')) {
            charge_leap = 0;
        }
        if (charge_leap > 0 && !builder.isFirstPerson()) {
            builder.get('head')
                .setY(builder.getModel().head.y + 2)
                .animate('easeOutQuint', charge_leap);
            builder.get('chest')
                .setXRotDegrees(15)
                .setY(builder.getModel().body.y + 2)
                .animate('easeOutQuint', charge_leap);
            builder.get('left_arm')
                .setXRotDegrees(120)
                .setY(builder.getModel().leftArm.y + 3)
                .setZ(builder.getModel().leftArm.z + 2)
                .animate('easeOutQuint', charge_leap);
            builder.get('right_arm')
                .setXRotDegrees(120)
                .setY(builder.getModel().rightArm.y + 3)
                .setZ(builder.getModel().rightArm.z + 2)
                .animate('easeOutQuint', charge_leap);
            builder.get('right_leg')
                .rotateX(builder.getModel().rightLeg.xRot * -0.5)
                .setZ(builder.getModel().rightLeg.z + 4.5)
                .animate('easeOutQuint', charge_leap);
            builder.get('left_leg')
                .rotateX(builder.getModel().leftLeg.xRot * -0.5)
                .setZ(builder.getModel().leftLeg.z + 2)
                .animate('easeOutQuint', charge_leap);
        }
        if (charge_leap > 0.0 && builder.isFirstPerson()) {
            builder.get('chest')
                .animate('easeInOutCirc', charge_leap);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('viriniteleap/anim', 201, (builder) => {
        let leap_anim = animationUtil.getAnimationTimerAbilityValue(
            builder.getPlayer(), 'darkside_aliens:virinite', 'leap_anim', builder.getPartialTicks(), 1, 8);
        builder.get('left_arm')
            .animate('easeInOutCubic', leap_anim);
        if (leap_anim > 0.0 && builder.isFirstPerson()) {
            builder.get('chest')
                .animate('easeInOutCubic', leap_anim);
        }

        if (abilityUtil.isEnabled(builder.getPlayer(), "darkside_aliens:virinite", "leap_anim")) {
            leap_anim = animationUtil.getAnimationTimerAbilityValue(
                builder.getPlayer(), 'darkside_aliens:virinite', 'leap_anim', builder.getPartialTicks(), 1, 16);
            if (leap_anim > 0.0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(-150)
                    .setZ(builder.getModel().leftArm.z - 1.5)
                    .animate('easeOutCirc', leap_anim);
                builder.get('right_arm')
                    .setXRotDegrees(-150)
                    .setZ(builder.getModel().rightArm.z - 1.5)
                    .animate('easeOutCirc', leap_anim);
                builder.get('left_leg')
                    .setXRotDegrees(25)
                    .animate('easeOutCirc', leap_anim);
                builder.get('right_leg')
                    .setXRotDegrees(25)
                    .animate('easeOutCirc', leap_anim);
                builder.get('chest')
                    .animate('easeOutQuint', leap_anim);

            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('darkside_aliens/virinitetentacle_anim', 15, (builder) => {
        const animation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'darkside_aliens:virinite', 'virinitetentacle_anim', builder.getPartialTicks());
        if (animation > 0.0) {
            if (builder.isFirstPerson()) {
                builder.get('right_arm').setZRotDegrees(68).animate('easeInOutBack', animation);
                builder.get('left_arm').setZRotDegrees(35).setXRotDegrees(-10).animate('easeInOutBack', animation);
            } else {

                builder.get('right_arm').setXRotDegrees(47.70372).setYRotDegrees(25.23098).setZRotDegrees(68.80252).setZ(builder.getModel().rightArm.z + 3).animate('easeInOutCirc', animation);
                builder.get('left_arm').setXRotDegrees(-90).setYRotDegrees(2.50525).setZRotDegrees(-37).setZ(builder.getModel().leftArm.z + -3).animate('easeInOutCirc', animation);
                builder.get('chest').setXRotDegrees(11.49181).setYRotDegrees(49.4919).setZRotDegrees(7.80244).animate('easeInOutCirc', animation);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('darkside/pursuit_1', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "darkside_aliens:virinite", "pursuit")) {
            let pursuit_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'darkside_aliens:virinite', 'pursuit', builder.getPartialTicks(), 1, 6);
            if (pursuit_1 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(-117.86082)
                    .setZRotDegrees(8.86042)
                    .setYRotDegrees(-4.65468)
                    .animate('easeOutBack', pursuit_1);
                builder.get('right_arm')
                    .setXRotDegrees(-118.32159)
                    .setZRotDegrees(-13.27207)
                    .setYRotDegrees(7.05309)
                    .animate('easeOutBack', pursuit_1);
            }
            if (pursuit_1 > 0 && builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(-117.86082)
                    .setZRotDegrees(8.86042)
                    .setYRotDegrees(-4.65468)
                    .setX(5)
                    .setY(-1)
                    .setZ(-2)
                    .animate('easeOutBack', pursuit_1);
                builder.get('right_arm')
                    .setXRotDegrees(-118.32159)
                    .setZRotDegrees(-13.27207)
                    .setYRotDegrees(7.05309)
                    .setX(-5)
                    .setY(-1)
                    .setZ(-2)
                    .animate('easeOutBack', pursuit_1);
            } else {
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('darkside/pursuit_2', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "darkside_aliens:virinite", "pursuit")) {
            let pursuit_2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'darkside_aliens:virinite', 'pursuit', builder.getPartialTicks(), 6, 10);
            if (pursuit_2 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(92.72)
                    .setZRotDegrees(33.5)
                    .setYRotDegrees(20.34)
                    .animate('easeOutBack', pursuit_2);
                builder.get('right_arm')
                    .setXRotDegrees(73.56347)
                    .setZRotDegrees(-20.48516)
                    .setYRotDegrees(-17.73187)
                    .animate('easeOutBack', pursuit_2);
                    builder.get('chest')
                .setXRotDegrees(15)
                .animate('easeOutQuint', pursuit_2);
                builder.get('head')
                .setXRotDegrees(13.89)
                .setZ(-2.44)
                .animate('easeOutCubic',pursuit_2);
            }
            if (pursuit_2 > 0 && builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(-62.72)
                    .setZRotDegrees(33.5)
                    .setYRotDegrees(20.34)
                    .setX(5)
                    .setY(-1)
                    .setZ(-2)
                    .animate('easeOutBack', pursuit_2);
                builder.get('right_arm')
                    .setXRotDegrees(73.56347)
                    .setZRotDegrees(-20.48516)
                    .setYRotDegrees(-17.73187)
                    .setX(-5)
                    .setY(-1)
                    .setZ(-2)
                    .animate('easeOutBack', pursuit_2);
                builder.get('chest')
                .setXRotDegrees(15)
                .animate('easeOutQuint', pursuit_2);
            } else {
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('darkside_aliens/virinite_climb_onwall', 10, (builder) => {
        const on_wall = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'darkside_aliens:virinite', 'surface_climbing_anim', builder.getPartialTicks());
        if (on_wall > 0.0) {
            if (builder.isFirstPerson()) {
            } else {
                builder.get('left_arm')
                    .setXRotDegrees(-145)
                    .animate('InOutCubic', on_wall);
                builder.get('right_arm')
                    .setXRotDegrees(-145)
                    .animate('InOutCubic', on_wall);
                builder.get('body')
                    .translateZ(0)
                    .animate('InOutCubic', on_wall);
                builder.get('right_leg')
                    .setZ(builder.getModel().rightLeg.z - 1)
                    .setXRotDegrees(-10)
                    .animate('InOutCubic', on_wall);
                builder.get('left_leg')
                    .setZ(builder.getModel().leftLeg.z - 1)
                    .setXRotDegrees(-10)
                    .animate('InOutCubic', on_wall);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('darkside_aliens/virinite_climb_1', 10, (builder) => {
        const climb_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'darkside_aliens:virinite', 'climb_1', builder.getPartialTicks());
        if (climb_1 > 0.0) {
            if (builder.isFirstPerson()) {
            } else {
                builder.get('right_arm')
                    .setXRotDegrees(-135)
                    .animate('easeInOutSine', climb_1);
                builder.get('left_arm')
                    .setY(builder.getModel().leftArm.y + 5)
                    .setXRotDegrees(-160)
                    .animate('easeInOutSine', climb_1);
                builder.get('right_leg')
                    .setY(builder.getModel().rightLeg.y - 7)
                    .setZ(builder.getModel().rightLeg.z - 2)
                    .setXRotDegrees(-10)
                    .animate('easeInOutSine', climb_1);
                builder.get('left_leg')
                    .setZ(builder.getModel().leftLeg.z - 2)
                    .setXRotDegrees(10)
                    .animate('easeInOutSine', climb_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('darkside_aliens/virinite_climb_2', 10, (builder) => {
        const climb_2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'darkside_aliens:virinite', 'climb_2', builder.getPartialTicks());
        if (climb_2 > 0.0) {
            if (builder.isFirstPerson()) {
            } else {
                builder.get('right_arm')
                    .setY(builder.getModel().leftArm.y + 5)
                    .setXRotDegrees(-160)
                    .animate('easeInOutSine', climb_2);
                builder.get('left_arm')
                    .setXRotDegrees(-135)
                    .animate('easeInOutSine', climb_2);
                builder.get('left_leg')
                    .setY(builder.getModel().rightLeg.y - 7)
                    .setZ(builder.getModel().rightLeg.z - 2)
                    .setXRotDegrees(-10)
                    .animate('easeInOutSine', climb_2);
                builder.get('right_leg')
                    .setZ(builder.getModel().rightLeg.z - 2)
                    .setXRotDegrees(10)
                    .animate('easeInOutSine', climb_2);
            }
        }
    });
});