EntityEvents.hurt(event => {
    const { entity, source } = event;
    if (!entity.isPlayer()) return;

    const player = entity;
    const hasVirinite = palladium.abilities.hasPower(player, 'darkside_aliens:virinite');
    if (!hasVirinite) return;

    const lastSource = source.getType()
    const type_damage = String(lastSource || "unknown");
    const data = player.persistentData;

    player.server.schedule(1, () => {
        if (!palladium.abilities.isUnlocked(player, 'darkside_aliens:virinite', 'adaptation')) return;

        const currentTime = player.level.time;
        const lastTrigger = data.getLong("virinite_adapt_tick") || 0;

        if (["onFire"].includes(type_damage)) {
            palladium.scoreboard.addScore(player, 'Virinite.AdaptationFire', 1);
        }
        if (currentTime - lastTrigger >= 20) {
            if (["inFire", "hotFloor", "lava", "dragon_fire"].includes(type_damage)) {
                palladium.scoreboard.addScore(player, 'Virinite.AdaptationFire', 1);
                data.putLong("virinite_adapt_tick", currentTime);
            }
        }
        if (["mob_projectile", "arrow", "taczbullets","gumball"].includes(type_damage)) {
            palladium.scoreboard.addScore(player, 'Virinite.AdaptationProjectile', 1);
        }
        if (["wither"].includes(type_damage)) {
            palladium.scoreboard.addScore(player, 'Virinite.AdaptationWither', 1);
        }
        if (["sonic_boom"].includes(type_damage)) {
            palladium.scoreboard.addScore(player, 'Virinite.AdaptationSonicBoom', 5);
        }
        if (["radiation"].includes(type_damage)) {
            palladium.scoreboard.addScore(player, 'Virinite.AdaptationRadiation', 1);
        }
        if (["acid"].includes(type_damage)) {
            palladium.scoreboard.addScore(player, 'Virinite.AdaptationAcid', 1);
        }
        if (["drown"].includes(type_damage)) {
            palladium.scoreboard.addScore(player, 'Virinite.AdaptationWater', 1);
        }
        if (["freeze", "dragon_ice"].includes(type_damage)) {
            palladium.scoreboard.addScore(player, 'Virinite.AdaptationIce', 1);
        }
        if (["abyssal"].includes(type_damage)) {
            palladium.scoreboard.addScore(player, 'Virinite.AdaptationAbyssal', 1);
        }
    });
});
