EntityEvents.hurt(event => {
    const { entity: target, source } = event;
    const attacker = source?.actual;

    // Always check for nulls early to avoid interference
    if (!target || !target.isLiving() || !attacker || !attacker.isLiving()) return;

    // --- ATTACKER logic: if attacker has virinite tier 3 ---
    if (attacker.isPlayer() && palladium.abilities.isEnabled(attacker, 'darkside_aliens:virinite', 'tier_3')) {
        palladium.superpowers.addSuperpower(target, 'darkside_aliens:t3marked');
        target.addTag('LockedOn');
    }

    // --- VICTIM logic: if victim has virinite tier 3 ---
    if (palladium.abilities.isEnabled(target, 'darkside_aliens:virinite', 'tier_3')) {
        palladium.superpowers.addSuperpower(attacker, 'darkside_aliens:t3marked');
        attacker.addTag('LockedOn');
    }
});
