EntityEvents.hurt(event => {
    const { entity: target, source } = event;
    const attacker = source?.actual;

    if (!target || !target.isLiving() || !attacker || !attacker.isLiving()) return;

    // --- ATTACKER logic: if attacker has virinite tier 3 ---
    if (attacker.isPlayer() && palladium.abilities.isEnabled(attacker, 'darkside_aliens:virinite', 'tier_3')) {
        target.addTag('LockedOn');
        
        // --- VICTIM logic: if victim has virinite tier 3 ---
        if (palladium.abilities.isEnabled(target, 'darkside_aliens:virinite', 'tier_3')) {
            attacker.addTag('LockedOn');
        }
    }
});

let undeadHosts = [
    "minecraft:zombie",
    "minecraft:husk",
    "minecraft:drowned",
    "minecraft:skeleton",
    "minecraft:stray",
    "minecraft:wither_skeleton",
    "minecraft:zoglin",
    "minecraft:zombified_piglin",
    "minecraft:zombie_villager",
    "born_in_chaos_v1:barrel_zombie",
    "born_in_chaos_v1:zombie_bruiser",
    "born_in_chaos_v1:pumpkin_bruiser",
    "born_in_chaos_v1:zombie_clown",
    "born_in_chaos_v1:zombie_clown_not_despawn",
    "born_in_chaos_v1:zombie_fisherman",
    "born_in_chaos_v1:zombie_lumberjack",
    "born_in_chaos_v1:decaying_zombie",
    "born_in_chaos_v1:swarmer",
    "born_in_chaos_v1:corpse_fly",
    "born_in_chaos_v1:door_knight",
    "born_in_chaos_v1:door_knight_not_despawn",
    "born_in_chaos_v1:lifestealer",
    "born_in_chaos_v1:lifestealer_true_form",
    "born_in_chaos_v1:baby_skeleton",
    "born_in_chaos_v1:siamese_skeletons",
    "born_in_chaos_v1:decrepit_skeleton",
    "born_in_chaos_v1:spirit_guide",
    "born_in_chaos_v1:bonescaller",
    "born_in_chaos_v1:bonescaller_not_despawn",
    "born_in_chaos_v1:supreme_bonescaller",
    "born_in_chaos_v1:skeleton_demoman",
    "born_in_chaos_v1:skeleton_thrasher",
    "born_in_chaos_v1:decaying_zombie_not_despawn",
    "cataclysm:draugr",
    "cataclysm:royal_draugr",
    "cataclysm:elite_draugr",
    "cataclysm:aptrgangr",
    "cataclysm:summoned_ignited_berserker",
    "cataclysm:ignited_berserker",
    "cataclysm:ignited_revenant",
    "iceandfire:dread_thrall",
    "iceandfire:dread_lich",
    "mutantmonsters:mutant_zombie",
    "mutantmonsters:mutant_skeleton",
    "irons_spellbooks:summoned_zombie"
]

let LivingEntity = Java.loadClass("net.minecraft.world.entity.LivingEntity")

undeadHosts.forEach(id => {
    EntityJSEvents.addGoals(id, event => {
        event.nearestAttackableTarget(
            1,
            LivingEntity,
            10,
            true,
            false,
            entity => entity.tags.contains("LockedOn")
        )
    })
})