// kubejs/server_scripts/debate_toggle.js

ServerEvents.commandRegistry(event => {
  const { commands: Commands } = event;

  event.register(
    Commands.literal('persistent_adapt')
      .requires(source => source.hasPermission(2)) // OP only
      .then(
        Commands.literal('disable')
          .executes(ctx => {
            const player = ctx.getSource().getPlayerOrException();
            const server = ctx.source.server;

            // Create objective if missing
            server.runCommandSilent('scoreboard objectives add infadapt dummy');

            // Set THIS player's score to 1
            server.runCommandSilent(`scoreboard players set ${player.getName().getString()} infadapt 0`);

            ctx.source.sendSuccess({ text: `§aAdaptations are now normal for ${player.getName().getString()}` }, true);
            return 1;
          })
      )
      .then(
        Commands.literal('enable')
          .executes(ctx => {
            const player = ctx.getSource().getPlayerOrException();
            const server = ctx.source.server;

            // Create objective if missing
            server.runCommandSilent('scoreboard objectives add infadapt dummy');

            // Set THIS player's score to 1
            server.runCommandSilent(`scoreboard players set ${player.getName().getString()} infadapt 1`);

            ctx.source.sendSuccess({ text: `§cAdaptations are now persistent for ${player.getName().getString()}` }, true);
            return 1;
          })
      )
  );
});
