PlayerEvents.tick(event => {
    const player = event.player;
    const hasVirinite = palladium.abilities.hasPower(player, 'darkside_aliens:virinite');
     // safer tag check
    const tags = player.getTags()
    const hasFragile = tags.contains('Darkside.Fragile');

    if (!hasVirinite) return;
    if (palladium.abilities.isUnlocked(player, 'darkside_aliens:virinite', 'tier_3')) {
        if (isDead(player) && !hasFragile) {
            player.potionEffects.add('minecraft:regeneration', 40, 20, true, false);
            player.addTag('Darkside.Fragile');
        }
    }
});

function isDead(player) {
    return player.health <= 5 || !player.isAlive();
}
