/*
 * Decompiled with CFR 0.152.
 */
package net.kaster.mrmod.items;

import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import net.kaster.mrmod.items.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FoodSpoilHandler {
    private static final String TAG_CREATED = "CreatedTime";
    private static final long SPOIL_TIME_TICKS = 48000L;
    private static final float BARREL_MULTIPLIER = 2.0f;
    private static final float TINKAN_MULTIPLIER = 5.0f;
    private static final float TINKANFISH_MULTIPLIER = 5.0f;
    private static final float TINKANCHICKEN_MULTIPLIER = 5.0f;
    private static final float TINKANTOMATO_MULTIPLIER = 5.0f;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.f_46443_) {
            return;
        }
        long gameTime = level.m_46467_();
        FoodSpoilHandler.normalizeContainer(player.m_150109_().m_6643_(), idx -> player.m_150109_().m_8020_(idx), (idx, stack) -> player.m_150109_().m_6836_(idx.intValue(), stack), gameTime);
        for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
            long spoilTime;
            long created;
            Item item;
            ItemStack stack2 = player.m_150109_().m_8020_(slot);
            if (stack2.m_41619_() || !FoodSpoilHandler.isSubjectToSpoil(item = stack2.m_41720_()) || gameTime - (created = FoodSpoilHandler.getOrSetCreated(stack2, gameTime)) < (spoilTime = FoodSpoilHandler.getSpoilTime(item))) continue;
            player.m_150109_().m_6836_(slot, new ItemStack((ItemLike)Items.f_42583_, stack2.m_41613_()));
        }
        player.m_150109_().m_6596_();
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Level level = event.getLevel();
        if (level.m_8055_(pos = event.getPos()).m_60734_() != Blocks.f_50618_) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof BarrelBlockEntity)) {
            return;
        }
        BarrelBlockEntity barrel = (BarrelBlockEntity)be;
        FoodSpoilHandler.processBarrel(level, barrel);
    }

    private static void processBarrel(Level world, BarrelBlockEntity barrel) {
        long gameTime = world.m_46467_();
        FoodSpoilHandler.normalizeContainer(barrel.m_6643_(), arg_0 -> ((BarrelBlockEntity)barrel).m_8020_(arg_0), (arg_0, arg_1) -> ((BarrelBlockEntity)barrel).m_6836_(arg_0, arg_1), gameTime);
        for (int slot = 0; slot < barrel.m_6643_(); ++slot) {
            long spoilTime;
            long created;
            Item item;
            ItemStack stack = barrel.m_8020_(slot);
            if (stack.m_41619_() || !FoodSpoilHandler.isSubjectToSpoil(item = stack.m_41720_()) || gameTime - (created = FoodSpoilHandler.getOrSetCreated(stack, gameTime)) < (spoilTime = (long)((float)FoodSpoilHandler.getSpoilTime(item) * 2.0f))) continue;
            barrel.m_6836_(slot, new ItemStack((ItemLike)Items.f_42583_, stack.m_41613_()));
        }
        barrel.m_6596_();
    }

    private static void normalizeContainer(int size, IntFunction<ItemStack> getter, BiConsumer<Integer, ItemStack> setter, long now) {
        ItemKey key;
        Item item;
        ItemStack stack;
        int slot;
        HashMap<ItemKey, Long> minCreatedByType = new HashMap<ItemKey, Long>();
        for (slot = 0; slot < size; ++slot) {
            stack = getter.apply(slot);
            if (stack.m_41619_() || !FoodSpoilHandler.isSubjectToSpoil(item = stack.m_41720_())) continue;
            key = new ItemKey(item, FoodSpoilHandler.stripCreatedForCompare(stack));
            long created = FoodSpoilHandler.getOrSetCreated(stack, now);
            minCreatedByType.merge(key, created, Math::min);
        }
        if (minCreatedByType.isEmpty()) {
            return;
        }
        for (slot = 0; slot < size; ++slot) {
            Long minCreated;
            stack = getter.apply(slot);
            if (stack.m_41619_() || !FoodSpoilHandler.isSubjectToSpoil(item = stack.m_41720_()) || (minCreated = (Long)minCreatedByType.get(key = new ItemKey(item, FoodSpoilHandler.stripCreatedForCompare(stack)))) == null) continue;
            FoodSpoilHandler.setCreated(stack, minCreated);
            setter.accept(slot, stack);
        }
    }

    private static CompoundTag stripCreatedForCompare(ItemStack stack) {
        CompoundTag src = stack.m_41783_();
        if (src == null) {
            return null;
        }
        CompoundTag copy = src.m_6426_();
        copy.m_128473_(TAG_CREATED);
        return copy.m_128456_() ? null : copy;
    }

    private static boolean isSubjectToSpoil(Item item) {
        if (!item.m_41472_()) {
            return false;
        }
        return item != Items.f_42583_;
    }

    private static long getSpoilTime(Item item) {
        long spoilTime = 48000L;
        if (item == ModItems.TINKAN.get() || item == ModItems.TINKANFISH.get() || item == ModItems.TINKANCHICKEN.get() || item == ModItems.TINKANTOMATO.get()) {
            spoilTime = (long)((float)spoilTime * 5.0f);
            if (item == ModItems.TINKANFISH.get()) {
                spoilTime = (long)((float)spoilTime * 5.0f);
            }
            if (item == ModItems.TINKANCHICKEN.get()) {
                spoilTime = (long)((float)spoilTime * 5.0f);
            }
            if (item == ModItems.TINKANTOMATO.get()) {
                spoilTime = (long)((float)spoilTime * 5.0f);
            }
        }
        return spoilTime;
    }

    private static long getOrSetCreated(ItemStack stack, long now) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_CREATED)) {
            tag.m_128356_(TAG_CREATED, now);
            return now;
        }
        return tag.m_128454_(TAG_CREATED);
    }

    private static void setCreated(ItemStack stack, long value) {
        stack.m_41784_().m_128356_(TAG_CREATED, value);
    }

    private record ItemKey(Item item, CompoundTag otherTags) {
    }
}

