/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.PigRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PigNPC
extends PigRaw
implements StandardEasyNPC<PigRaw> {
    public static final String ID = "pig";

    public PigNPC(EntityType<? extends Pig> entityType, Level level) {
        this(entityType, level, PigRaw.VariantType.DEFAULT);
    }

    public PigNPC(EntityType<? extends Pig> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
        this.setInvulnerable(true);
        this.refreshGroundNavigation();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    @Override
    public boolean canUseOffHand() {
        return false;
    }

    @Override
    public int getEntityDialogTop() {
        return -37;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.PIG_AMBIENT);
        soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.PIG_DEATH);
        soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.PIG_HURT);
        soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.PIG_STEP);
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void registerGoals() {
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

