/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.SpiderRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpiderNPC
extends SpiderRaw
implements StandardEasyNPC<SpiderRaw> {
    public static final String ID = "spider";
    public static final String ID_CAVE_SPIDER = "cave_spider";

    public SpiderNPC(EntityType<? extends Spider> entityType, Level level) {
        this(entityType, level, SpiderRaw.VariantType.SPIDER);
    }

    public SpiderNPC(EntityType<? extends Spider> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
        this.setInvulnerable(true);
        this.getEntityAttributes().setEnvironmentalAttributes(this.getEntityAttributes().getEnvironmentalAttributes().withCanBreathUnderwater(true));
        this.refreshGroundNavigation();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    @Override
    public boolean canUseArmor() {
        return false;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        SpiderRaw.VariantType soundVariant = SpiderRaw.VariantType.valueOf(variantName);
        switch (soundVariant) {
            case CAVE_SPIDER: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.SPIDER_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.SPIDER_HURT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.SPIDER_DEATH);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.SPIDER_STEP);
                break;
            }
            default: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.SPIDER_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.SPIDER_HURT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.SPIDER_DEATH);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.SPIDER_STEP);
            }
        }
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void registerGoals() {
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

