/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.screen;

import de.markusbordihn.easynpc.client.gui.InventoryScreenHandler;
import de.markusbordihn.easynpc.client.renderer.manager.RendererManager;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class EntityScreenRenderer {
    protected EntityScreenRenderer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderEntity(GuiGraphics guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config, float mouseX, float mouseY) {
        int bottom;
        int top;
        int right;
        int left;
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderState backupState = new EntityRenderState(livingEntity, easyNPC);
        EntityScreenRenderer.applyRenderModifications(easyNPC, config);
        int renderScale = config.scale();
        if (config.scissorBox() != null) {
            CustomScale originalScale;
            float multiplier = config.scissorBox().scaleMultiplier();
            renderScale = (int)((float)config.scale() * multiplier);
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null && (originalScale = modelData.getModelPartScale(ModelPartType.ROOT)) != null) {
                float adjustment = 1.0f / multiplier;
                modelData.setModelPartScale(ModelPartType.ROOT, new CustomScale(originalScale.x() * adjustment, originalScale.y() * adjustment, originalScale.z() * adjustment));
            }
        }
        if (config.scissorBox() != null && config.scissorBox().hasCustomScissor()) {
            left = config.x() + config.scissorBox().left();
            right = left + config.scissorBox().width();
            top = config.y() + config.scissorBox().top();
            bottom = top + config.scissorBox().height();
        } else {
            int entityWidth = (int)((float)renderScale * 2.5f);
            int entityHeight = (int)((float)renderScale * 3.0f);
            left = config.x() - entityWidth / 2;
            right = config.x() + entityWidth / 2;
            top = config.y() - entityHeight;
            bottom = config.y() + (int)((float)renderScale * 0.5f);
        }
        try {
            RendererManager.setScreenRendering(true);
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)left, (int)top, (int)right, (int)bottom, (int)renderScale, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)livingEntity);
        }
        finally {
            RendererManager.setScreenRendering(false);
        }
        EntityScreenRenderer.restoreEntityState(easyNPC, backupState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderEntityRaw(GuiGraphics guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config, float mouseX, float mouseY) {
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        try {
            InventoryScreenHandler.setBypassMixin(true);
            EntityScreenRenderer.renderEntity(guiGraphics, easyNPC, config, mouseX, mouseY);
        }
        finally {
            InventoryScreenHandler.setBypassMixin(false);
        }
    }

    protected static void applyRenderModifications(EasyNPC<?> easyNPC, EntityRenderConfig config) {
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderOverrides overrides = config.overrides();
        if (overrides.invisible() != null) {
            entity.setInvisible(overrides.invisible().booleanValue());
        }
        if (overrides.hideNameTag() != null && overrides.hideNameTag().booleanValue()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft != null) {
                minecraft.options.hideGui = true;
            } else {
                livingEntity.setCustomName(null);
                livingEntity.setCustomNameVisible(false);
            }
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (overrides.rootRotation() != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, overrides.rootRotation());
            }
            if (overrides.rootScale() != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, overrides.rootScale());
            }
            if (overrides.modelPose() != null) {
                modelData.setModelPose(overrides.modelPose());
            }
        }
        if (overrides.entityPose() != null) {
            entity.setPose(overrides.entityPose());
        }
    }

    protected static void restoreEntityState(EasyNPC<?> easyNPC, EntityRenderState backupState) {
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        livingEntity.setCustomName(backupState.customName);
        livingEntity.setCustomNameVisible(backupState.shouldShowName);
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            minecraft.options.hideGui = backupState.minecraftHideGui;
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (backupState.rootRotation != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, backupState.rootRotation);
            }
            if (backupState.rootScale != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, backupState.rootScale);
            }
            if (backupState.modelPose != null) {
                modelData.setModelPose(backupState.modelPose);
            }
        }
        if (backupState.entityPose != null) {
            entity.setPose(backupState.entityPose);
        }
    }

    protected static class EntityRenderState {
        final Component customName;
        final boolean shouldShowName;
        final boolean minecraftHideGui;
        final CustomRotation rootRotation;
        final CustomScale rootScale;
        final ModelPose modelPose;
        final Pose entityPose;

        EntityRenderState(LivingEntity livingEntity, EasyNPC<?> easyNPC) {
            this.customName = livingEntity.getCustomName();
            this.shouldShowName = livingEntity.shouldShowName();
            Minecraft minecraft = Minecraft.getInstance();
            this.minecraftHideGui = minecraft != null ? minecraft.options.hideGui : false;
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null) {
                this.rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
                this.rootScale = modelData.getModelPartScale(ModelPartType.ROOT);
                this.modelPose = modelData.getModelPose();
            } else {
                this.rootRotation = null;
                this.rootScale = null;
                this.modelPose = null;
            }
            this.entityPose = easyNPC.getEntity().getPose();
        }
    }
}

