/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ConditionDataSet {
    public static final ConditionDataSet EMPTY = new ConditionDataSet();
    public static final String CONDITION_DATA_SET_TAG = "ConditionDataSet";
    private final Set<ConditionDataEntry> conditionDataEntries = new LinkedHashSet<ConditionDataEntry>();

    public ConditionDataSet() {
    }

    public ConditionDataSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public boolean isEmpty() {
        return this.conditionDataEntries.isEmpty();
    }

    public int size() {
        return this.conditionDataEntries.size();
    }

    public Set<ConditionDataEntry> getConditions() {
        return new LinkedHashSet<ConditionDataEntry>(this.conditionDataEntries);
    }

    public List<ConditionDataEntry> getConditionsList() {
        return new ArrayList<ConditionDataEntry>(this.conditionDataEntries);
    }

    public ConditionDataEntry getCondition(UUID id) {
        for (ConditionDataEntry entry : this.conditionDataEntries) {
            if (!entry.getId().equals(id)) continue;
            return entry;
        }
        return null;
    }

    public boolean hasCondition(UUID id) {
        return this.getCondition(id) != null;
    }

    public void add(ConditionDataEntry conditionDataEntry) {
        if (conditionDataEntry != null && conditionDataEntry.isValid()) {
            this.remove(conditionDataEntry.getId());
            this.conditionDataEntries.add(conditionDataEntry);
        }
    }

    public boolean remove(UUID id) {
        return this.conditionDataEntries.removeIf(entry -> entry.getId().equals(id));
    }

    public void update(ConditionDataEntry conditionDataEntry) {
        if (conditionDataEntry != null && conditionDataEntry.isValid()) {
            this.remove(conditionDataEntry.getId());
            this.conditionDataEntries.add(conditionDataEntry);
        }
    }

    public void clear() {
        this.conditionDataEntries.clear();
    }

    public void moveUp(ConditionDataEntry conditionDataEntry) {
        if (conditionDataEntry == null) {
            return;
        }
        ArrayList<ConditionDataEntry> list = new ArrayList<ConditionDataEntry>(this.conditionDataEntries);
        int index = list.indexOf(conditionDataEntry);
        if (index > 0) {
            list.remove(index);
            list.add(index - 1, conditionDataEntry);
            this.conditionDataEntries.clear();
            this.conditionDataEntries.addAll(list);
        }
    }

    public void moveDown(ConditionDataEntry conditionDataEntry) {
        if (conditionDataEntry == null) {
            return;
        }
        ArrayList<ConditionDataEntry> list = new ArrayList<ConditionDataEntry>(this.conditionDataEntries);
        int index = list.indexOf(conditionDataEntry);
        if (index >= 0 && index < list.size() - 1) {
            list.remove(index);
            list.add(index + 1, conditionDataEntry);
            this.conditionDataEntries.clear();
            this.conditionDataEntries.addAll(list);
        }
    }

    public void load(CompoundTag compoundTag) {
        if (compoundTag == null || !compoundTag.contains(CONDITION_DATA_SET_TAG)) {
            return;
        }
        CompoundTag conditionDataSetTag = compoundTag.getCompoundOrEmpty(CONDITION_DATA_SET_TAG);
        this.conditionDataEntries.clear();
        ListTag conditionDataEntriesTag = conditionDataSetTag.getListOrEmpty(CONDITION_DATA_SET_TAG);
        for (int i = 0; i < conditionDataEntriesTag.size(); ++i) {
            CompoundTag conditionDataEntryTag = conditionDataEntriesTag.getCompoundOrEmpty(i);
            ConditionDataEntry conditionDataEntry = new ConditionDataEntry(conditionDataEntryTag);
            if (!conditionDataEntry.isValid()) continue;
            this.conditionDataEntries.add(conditionDataEntry);
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        return this.save(compoundTag, CONDITION_DATA_SET_TAG);
    }

    public CompoundTag save(CompoundTag compoundTag, String tag) {
        if (this.isEmpty()) {
            return compoundTag;
        }
        CompoundTag conditionDataSetTag = new CompoundTag();
        ListTag conditionDataEntriesTag = new ListTag();
        for (ConditionDataEntry conditionDataEntry : this.conditionDataEntries) {
            if (conditionDataEntry == null || !conditionDataEntry.isValid()) continue;
            conditionDataEntriesTag.add((Object)conditionDataEntry.createTag());
        }
        if (!conditionDataEntriesTag.isEmpty()) {
            conditionDataSetTag.put(CONDITION_DATA_SET_TAG, (Tag)conditionDataEntriesTag);
            compoundTag.put(tag, (Tag)conditionDataSetTag);
        }
        return compoundTag;
    }

    public boolean hasConditionData() {
        return !this.isEmpty();
    }

    public String toString() {
        return "ConditionDataSet[size=" + this.size() + ", entries=" + String.valueOf(this.conditionDataEntries) + "]";
    }
}

