/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc;

import de.markusbordihn.easynpc.data.status.StatusDataType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ServerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.StatusDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttributeHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.BaseTickHandler;
import java.util.EnumMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface EasyNPCBase<E extends PathfinderMob>
extends EasyNPC<E>,
ActionEventDataCapable<E>,
ActionHandler<E>,
AttackDataCapable<E>,
AttributeDataCapable<E>,
AttributeHandler<E>,
BaseTickHandler<E>,
ConfigDataCapable<E>,
ConfigurationDataCapable<E>,
DialogDataCapable<E>,
DisplayAttributeDataCapable<E>,
ModelDataCapable<E>,
NavigationDataCapable<E>,
ObjectiveDataCapable<E>,
OwnerDataCapable<E>,
PresetDataCapable<E>,
ProfessionDataCapable<E>,
RenderDataCapable<E>,
ServerDataCapable<E>,
SkinDataCapable<E>,
SoundDataCapable<E>,
StatusDataCapable<E>,
TickerDataCapable<E>,
TradingDataCapable<E>,
VariantDataCapable<E> {
    public static void registerEasyNPCSyncedData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        AttackDataCapable.registerSyncedAttackData(map, entityClass);
        AttributeDataCapable.registerSyncedAttributeData(map, entityClass);
        DisplayAttributeDataCapable.registerSyncedDisplayAttributeData(map, entityClass);
        ModelDataCapable.registerSyncedModelData(map, entityClass);
        NavigationDataCapable.registerSyncedNavigationData(map, entityClass);
        OwnerDataCapable.registerSyncedOwnerData(map, entityClass);
        ProfessionDataCapable.registerSyncedProfessionData(map, entityClass);
        RenderDataCapable.registerSyncedRenderData(map, entityClass);
        SkinDataCapable.registerSyncedSkinData(map, entityClass);
        SoundDataCapable.registerSyncedSoundData(map, entityClass);
        TradingDataCapable.registerSyncedTradingData(map, entityClass);
        VariantDataCapable.registerSyncedVariantData(map, entityClass);
    }

    default public void registerEasyNPCDefaultVariant(Enum<?> variant) {
        SoundDataCapable soundData;
        log.info("Register default variant for {} with variant {} ...", (Object)this, variant);
        VariantDataCapable variantData = this.getEasyNPCVariantData();
        if (variantData != null) {
            variantData.setSkinVariantType(variant);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.registerDefaultSoundData(variant);
        }
    }

    default public SpawnGroupData finalizeEasyNPCSpawn(SpawnGroupData spawnGroupData) {
        StatusDataCapable statusData;
        log.info("Finalize spawn for {} ...", (Object)this);
        NavigationDataCapable navigationData = this.getEasyNPCNavigationData();
        if (navigationData != null && !navigationData.hasHomePosition()) {
            navigationData.setHomePosition(this.getEntity().blockPosition());
        }
        if ((statusData = this.getEasyNPCStatusData()) == null || !statusData.getStatusDataFlag(StatusDataType.FINALIZED)) {
            ActionEventDataCapable actionEventData;
            log.debug("Register default data for {} ...", (Object)this);
            ObjectiveDataCapable objectiveData = this.getEasyNPCObjectiveData();
            if (objectiveData != null) {
                objectiveData.registerStandardObjectives();
            }
            if ((actionEventData = this.getEasyNPCActionEventData()) != null) {
                actionEventData.registerDefaultActionInteractionEvents();
            }
        } else {
            log.debug("Skip default data registration for {} ...", (Object)this);
        }
        return spawnGroupData;
    }

    default public void defineEasyNPCBaseSyncedData(SynchedEntityData.Builder builder) {
        TradingDataCapable tradingData;
        SoundDataCapable soundData;
        SkinDataCapable skinData;
        RenderDataCapable renderData;
        ProfessionDataCapable professionData;
        OwnerDataCapable ownerData;
        NavigationDataCapable navigationData;
        ModelDataCapable modelData;
        DisplayAttributeDataCapable displayAttributeData;
        DialogDataCapable dialogData;
        AttributeDataCapable attributeData;
        AttackDataCapable attackData;
        ActionEventDataCapable actionEventData;
        log.debug("Define synced data for {} with {}", (Object)this, (Object)builder);
        VariantDataCapable variantData = this.getEasyNPCVariantData();
        if (variantData != null) {
            variantData.defineSynchedVariantData(builder);
        }
        if ((actionEventData = this.getEasyNPCActionEventData()) != null) {
            actionEventData.defineSynchedActionData(builder);
        }
        if ((attackData = this.getEasyNPCAttackData()) != null) {
            attackData.defineSynchedAttackData(builder);
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.defineSynchedAttributeData(builder);
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.defineSynchedDialogData(builder);
        }
        if ((displayAttributeData = this.getEasyNPCDisplayAttributeData()) != null) {
            displayAttributeData.defineSynchedDisplayAttributeData(builder);
        }
        if ((modelData = this.getEasyNPCModelData()) != null) {
            modelData.defineSynchedModelData(builder);
        }
        if ((navigationData = this.getEasyNPCNavigationData()) != null) {
            navigationData.defineSynchedNavigationData(builder);
        }
        if ((ownerData = this.getEasyNPCOwnerData()) != null) {
            ownerData.defineSynchedOwnerData(builder);
        }
        if ((professionData = this.getEasyNPCProfessionData()) != null) {
            professionData.defineSynchedProfessionData(builder);
        }
        if ((renderData = this.getEasyNPCRenderData()) != null) {
            renderData.defineSynchedRenderData(builder);
        }
        if ((skinData = this.getEasyNPCSkinData()) != null) {
            skinData.defineSynchedSkinData(builder);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.defineSynchedSoundData(builder);
        }
        if ((tradingData = this.getEasyNPCTradingData()) != null) {
            tradingData.defineSynchedTradingData(builder);
        }
    }

    default public void defineEasyNPCBaseServerSideData() {
        PresetDataCapable presetData;
        ObjectiveDataCapable objectiveData;
        DialogDataCapable dialogData;
        if (!this.isServerSideInstance()) {
            return;
        }
        ServerDataCapable serverData = this.getEasyNPCServerData();
        if (serverData == null) {
            log.error("No server data available for {}", (Object)this.getEntityUUID());
            return;
        }
        if (!serverData.hasServerEntityData()) {
            log.info("Register server-side data for {} ...", (Object)this.getEntityUUID());
            serverData.defineServerEntityData();
        }
        log.info("Define custom server-side data for {} ...", (Object)this.getEntityUUID());
        ActionEventDataCapable actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData != null) {
            actionEventData.defineCustomActionData();
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.defineCustomDialogData();
        }
        if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
            objectiveData.defineCustomObjectiveData();
        }
        if ((presetData = this.getEasyNPCPresetData()) != null) {
            presetData.defineCustomPresetData();
        }
    }

    default public void addEasyNPCBaseAdditionalSaveData(ValueOutput valueOutput, HolderLookup.Provider provider) {
        VariantDataCapable variantData;
        TradingDataCapable tradingData;
        StatusDataCapable statusData;
        SoundDataCapable soundData;
        SkinDataCapable skinData;
        RenderDataCapable renderData;
        ProfessionDataCapable professionData;
        PresetDataCapable presetData;
        OwnerDataCapable ownerData;
        ObjectiveDataCapable objectiveData;
        NavigationDataCapable navigationData;
        ModelDataCapable modelData;
        DisplayAttributeDataCapable displayAttributeData;
        DialogDataCapable dialogData;
        ConfigDataCapable configData;
        AttributeDataCapable attributeData;
        AttackDataCapable attackData;
        log.debug("Add additional save data for {} with {}", (Object)this, (Object)provider);
        ActionEventDataCapable actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData != null) {
            actionEventData.addAdditionalActionData(valueOutput);
        }
        if ((attackData = this.getEasyNPCAttackData()) != null) {
            attackData.addAdditionalAttackData(valueOutput);
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.addAdditionalAttributeData(valueOutput);
        }
        if ((configData = this.getEasyNPCConfigData()) != null) {
            configData.addAdditionalConfigData(valueOutput);
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.addAdditionalDialogData(valueOutput);
        }
        if ((displayAttributeData = this.getEasyNPCDisplayAttributeData()) != null) {
            displayAttributeData.addAdditionalDisplayAttributeData(valueOutput);
        }
        if ((modelData = this.getEasyNPCModelData()) != null) {
            modelData.addAdditionalModelData(valueOutput);
        }
        if ((navigationData = this.getEasyNPCNavigationData()) != null) {
            navigationData.addAdditionalNavigationData(valueOutput);
        }
        if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
            objectiveData.addAdditionalObjectiveData(valueOutput);
        }
        if ((ownerData = this.getEasyNPCOwnerData()) != null) {
            ownerData.addAdditionalOwnerData(valueOutput);
        }
        if ((presetData = this.getEasyNPCPresetData()) != null) {
            presetData.addAdditionalPresetData(valueOutput);
        }
        if ((professionData = this.getEasyNPCProfessionData()) != null) {
            professionData.addAdditionalProfessionData(valueOutput);
        }
        if ((renderData = this.getEasyNPCRenderData()) != null) {
            renderData.addAdditionalRenderData(valueOutput);
        }
        if ((skinData = this.getEasyNPCSkinData()) != null) {
            skinData.addAdditionalSkinData(valueOutput);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.addAdditionalSoundData(valueOutput);
        }
        if ((statusData = this.getEasyNPCStatusData()) != null) {
            statusData.addAdditionalStatusData(valueOutput);
        }
        if ((tradingData = this.getEasyNPCTradingData()) != null) {
            tradingData.addAdditionalTradingData(valueOutput);
        }
        if ((variantData = this.getEasyNPCVariantData()) != null) {
            variantData.addAdditionalVariantData(valueOutput);
        }
    }

    default public void readEasyNPCBaseAdditionalSaveData(ValueInput valueInput, HolderLookup.Provider provider) {
        ObjectiveDataCapable objectiveData;
        TradingDataCapable tradingData;
        StatusDataCapable statusData;
        SoundDataCapable soundData;
        SkinDataCapable skinData;
        RenderDataCapable renderData;
        ProfessionDataCapable professionData;
        PresetDataCapable presetData;
        OwnerDataCapable ownerData;
        NavigationDataCapable navigationData;
        ModelDataCapable modelData;
        DisplayAttributeDataCapable displayAttributeData;
        DialogDataCapable dialogData;
        AttributeDataCapable attributeData;
        AttackDataCapable attackData;
        ActionEventDataCapable actionEventData;
        VariantDataCapable variantData;
        log.debug("Read additional save data for {} with {}", (Object)this, (Object)provider);
        ConfigDataCapable configData = this.getEasyNPCConfigData();
        if (configData != null) {
            configData.readAdditionalConfigData(valueInput);
        }
        if ((variantData = this.getEasyNPCVariantData()) != null) {
            variantData.readAdditionalVariantData(valueInput);
        }
        if ((actionEventData = this.getEasyNPCActionEventData()) != null) {
            actionEventData.readAdditionalActionData(valueInput);
        }
        if ((attackData = this.getEasyNPCAttackData()) != null) {
            attackData.readAdditionalAttackData(valueInput);
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.readAdditionalAttributeData(valueInput);
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.readAdditionalDialogData(valueInput);
        }
        if ((displayAttributeData = this.getEasyNPCDisplayAttributeData()) != null) {
            displayAttributeData.readAdditionalDisplayAttributeData(valueInput);
        }
        if ((modelData = this.getEasyNPCModelData()) != null) {
            modelData.readAdditionalModelData(valueInput);
        }
        if ((navigationData = this.getEasyNPCNavigationData()) != null) {
            navigationData.readAdditionalNavigationData(valueInput);
        }
        if ((ownerData = this.getEasyNPCOwnerData()) != null) {
            ownerData.readAdditionalOwnerData(valueInput);
        }
        if ((presetData = this.getEasyNPCPresetData()) != null) {
            presetData.readAdditionalPresetData(valueInput);
        }
        if ((professionData = this.getEasyNPCProfessionData()) != null) {
            professionData.readAdditionalProfessionData(valueInput);
        }
        if ((renderData = this.getEasyNPCRenderData()) != null) {
            renderData.readAdditionalRenderData(valueInput);
        }
        if ((skinData = this.getEasyNPCSkinData()) != null) {
            skinData.readAdditionalSkinData(valueInput);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.readAdditionalSoundData(valueInput);
        }
        if ((statusData = this.getEasyNPCStatusData()) != null) {
            statusData.readAdditionalStatusData(valueInput);
        }
        if ((tradingData = this.getEasyNPCTradingData()) != null) {
            tradingData.readAdditionalTradingData(valueInput);
        }
        if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
            objectiveData.readAdditionalObjectiveData(valueInput);
        }
        if (navigationData != null) {
            navigationData.refreshGroundNavigation();
        }
    }
}

