/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.status.StatusDataType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface StatusDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String DATA_STATUS_DATA_TAG = "Status";

    public EnumMap<StatusDataType, Boolean> getStatusDataFlags();

    default public boolean getStatusDataFlag(StatusDataType key) {
        return this.getStatusDataFlags().getOrDefault((Object)key, false);
    }

    default public void setStatusDataFlag(StatusDataType key, boolean value) {
        this.getStatusDataFlags().put(key, value);
    }

    default public void addAdditionalStatusData(ValueOutput valueOutput) {
        CompoundTag statusTag = new CompoundTag();
        if (!this.getStatusDataFlag(StatusDataType.FINALIZED)) {
            this.setStatusDataFlag(StatusDataType.FINALIZED, true);
        }
        for (Map.Entry<StatusDataType, Boolean> entry : this.getStatusDataFlags().entrySet()) {
            statusTag.putBoolean(entry.getKey().getTagName(), entry.getValue().booleanValue());
        }
        valueOutput.store(DATA_STATUS_DATA_TAG, CompoundTag.CODEC, (Object)statusTag);
    }

    default public void readAdditionalStatusData(ValueInput valueInput) {
        Optional compoundTagData = valueInput.read(DATA_STATUS_DATA_TAG, CompoundTag.CODEC);
        if (compoundTagData.isEmpty()) {
            return;
        }
        CompoundTag statusTag = (CompoundTag)compoundTagData.get();
        for (String key : statusTag.keySet()) {
            StatusDataType statusDataType = StatusDataType.get(key);
            if (statusDataType == null) continue;
            this.setStatusDataFlag(StatusDataType.get(key), statusTag.getBoolean(key).orElse(false));
        }
    }
}

