/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReloadHandler {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ReloadHandler() {
    }

    public static boolean reloadNPC(EasyNPC<?> easyNPC, ServerLevel serverLevel) {
        if (easyNPC == null || serverLevel == null) {
            log.error("Unable to reload NPC with invalid EasyNPC {} or ServerLevel {}!", easyNPC, (Object)serverLevel);
            return false;
        }
        PathfinderMob entity = easyNPC.getPathfinderMob();
        if (entity == null || !entity.isAlive()) {
            log.warn("Unable to reload NPC {} because entity is null or not alive!", (Object)easyNPC.getEntityUUID());
            return false;
        }
        TagValueOutput tagValueOutput = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
        easyNPC.getEntity().saveWithoutId((ValueOutput)tagValueOutput);
        CompoundTag compoundTag = tagValueOutput.buildResult();
        log.debug("Reloading NPC {} at position {}", (Object)easyNPC.getEntityUUID(), (Object)entity.position());
        entity.load(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)serverLevel.registryAccess(), (CompoundTag)compoundTag));
        CompoundTagUtils.fixLegacyCustomName((Entity)entity, compoundTag);
        entity.refreshDimensions();
        return true;
    }
}

