/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.level;

import de.markusbordihn.easynpc.data.spawner.SpawnerData;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseEasyNPCSpawner
extends BaseSpawner {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final Random random = new Random();
    private final SpawnerType spawnerType;
    private boolean isEasyNPC;
    private double oSpin;
    private double spin;
    private Entity displayEntity;
    private int maxNearbyEntities;
    private int maxSpawnDelay;
    private int minSpawnDelay;
    private int requiredPlayerRange;
    private int spawnCount;
    private int spawnDelay;
    private int spawnRange;
    private SpawnData nextSpawnData;
    private UUID easyNPCPresetUUID;
    private UUID easyNPCUUID;

    public BaseEasyNPCSpawner(SpawnerType spawnerType) {
        this.spawnerType = spawnerType;
        this.nextSpawnData = new SpawnData();
        this.spawnDelay = -1;
        CompoundTag compoundTag = new CompoundTag();
        SpawnerData.setSpawnData(spawnerType, compoundTag);
        this.updateSpawnData(compoundTag);
    }

    public void broadcastEvent(Level level, BlockPos blockPos, int eventId) {
        level.blockEvent(blockPos, Blocks.SPAWNER, eventId, 0);
    }

    public void setNextSpawnData(Level level, BlockPos blockPos, SpawnData spawnData) {
        super.setNextSpawnData(level, blockPos, spawnData);
        this.displayEntity = null;
        if (level != null) {
            BlockState blockState = level.getBlockState(blockPos);
            level.sendBlockUpdated(blockPos, blockState, blockState, 4);
        }
        TagValueOutput valueOutput = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
        this.save((ValueOutput)valueOutput);
        CompoundTag compoundTag = valueOutput.buildResult();
        this.updateSpawnData(compoundTag);
        log.debug("Updated spawn data for spawner at {} - isEasyNPC: {}", (Object)blockPos, (Object)this.isEasyNPC);
    }

    public void clientTick(Level level, BlockPos blockPos) {
        if (!this.isNearPlayer(level, blockPos, this.requiredPlayerRange)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            double x = (double)blockPos.getX() + level.random.nextDouble();
            double y = (double)blockPos.getY() + level.random.nextDouble();
            double z = (double)blockPos.getZ() + level.random.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + 1000.0 / ((double)this.spawnDelay + 200.0)) % 360.0;
        }
    }

    public void serverTick(ServerLevel serverLevel, BlockPos blockPos) {
        Entity entity;
        if (!this.isNearPlayer((Level)serverLevel, blockPos, this.requiredPlayerRange)) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.delay((Level)serverLevel, blockPos);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        if (!this.hasEasyNPC()) {
            return;
        }
        if (this.maxNearbyEntities == 1 && this.easyNPCUUID != null && (entity = serverLevel.getEntity(this.easyNPCUUID)) != null && entity.isAlive()) {
            this.delay((Level)serverLevel, blockPos);
            return;
        }
        if (this.easyNPCPresetUUID != null && LivingEntityManager.getEntityCountByPresetUUID(this.easyNPCPresetUUID) >= this.maxNearbyEntities) {
            this.delay((Level)serverLevel, blockPos);
            return;
        }
        this.spawnEasyNPC(serverLevel, blockPos);
    }

    public Entity getOrCreateDisplayEntity(Level level, BlockPos blockPos) {
        if (this.displayEntity == null) {
            CompoundTag compoundTag = this.nextSpawnData.getEntityToSpawn();
            if (compoundTag.getString("id").isEmpty()) {
                log.debug("No entity id in spawn data for spawner at {}", (Object)blockPos);
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)level, (EntitySpawnReason)EntitySpawnReason.SPAWNER, Function.identity());
            if (this.displayEntity != null) {
                log.debug("Created display entity {} for spawner at {}", (Object)this.displayEntity.getType(), (Object)blockPos);
            } else {
                log.warn("Failed to create display entity for spawner at {}", (Object)blockPos);
            }
        }
        return this.displayEntity;
    }

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }

    private boolean isNearPlayer(Level level, BlockPos pos, int requiredPlayerRange) {
        return level.hasNearbyAlivePlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)requiredPlayerRange);
    }

    private void delay(Level level, BlockPos pos) {
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.random.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.broadcastEvent(level, pos, 1);
    }

    private void spawnEasyNPC(ServerLevel level, BlockPos pos) {
        boolean spawned = false;
        for (int i = 0; i < this.spawnCount; ++i) {
            Mob mob;
            double finalZ;
            double finalY;
            double finalX;
            Entity entity;
            double z;
            ListTag posList;
            int posSize;
            CompoundTag entityTag = this.nextSpawnData.getEntityToSpawn();
            ValueInput valueInput = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)entityTag);
            Optional entityType = EntityType.by((ValueInput)valueInput);
            if (entityType.isEmpty()) {
                this.delay((Level)level, pos);
                return;
            }
            if (this.maxNearbyEntities > 1 && entityTag.contains("UUID")) {
                entityTag.remove("UUID");
            }
            double x = (posSize = (posList = entityTag.getListOrEmpty("Pos")).size()) >= 1 ? posList.getDouble(0).orElse(0.0) : (double)pos.getX() + (level.random.nextDouble() - level.random.nextDouble()) * (double)this.spawnRange + 0.5;
            double y = posSize >= 2 ? posList.getDouble(1).orElse(0.0) : (double)(pos.getY() + level.random.nextInt(3) - 1);
            double d = z = posSize >= 3 ? posList.getDouble(2).orElse(0.0) : (double)pos.getZ() + (level.random.nextDouble() - level.random.nextDouble()) * (double)this.spawnRange + 0.5;
            if (!level.noCollision(((EntityType)entityType.get()).getSpawnAABB(x, y, z))) {
                BlockPos possibleSpawnPositions;
                if (this.maxNearbyEntities <= 1 || (possibleSpawnPositions = (BlockPos)BlockPos.findClosestMatch((BlockPos)pos, (int)this.spawnRange, (int)this.spawnRange, possibleBlockPos -> level.noCollision(((EntityType)entityType.get()).getSpawnAABB((double)possibleBlockPos.getX() + 0.5, (double)possibleBlockPos.getY(), (double)possibleBlockPos.getZ() + 0.5)) && !level.getBlockState(possibleBlockPos.below()).isAir()).orElse(null)) == null) continue;
                x = (double)possibleSpawnPositions.getX() + 0.5;
                y = possibleSpawnPositions.getY();
                z = (double)possibleSpawnPositions.getZ() + 0.5;
            }
            if ((entity = EntityType.loadEntityRecursive((CompoundTag)entityTag, (Level)level, (EntitySpawnReason)EntitySpawnReason.SPAWNER, arg_0 -> BaseEasyNPCSpawner.lambda$spawnEasyNPC$1(finalX = x, finalY = y, finalZ = z, arg_0))) == null) {
                this.delay((Level)level, pos);
                return;
            }
            entity.snapTo(entity.getX(), entity.getY(), entity.getZ(), level.random.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                if (this.nextSpawnData.getCustomSpawnRules().isEmpty() && !mob.checkSpawnRules((LevelAccessor)level, EntitySpawnReason.SPAWNER) || !mob.checkSpawnObstruction((LevelReader)level)) continue;
                mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(mob.blockPosition()), EntitySpawnReason.SPAWNER, null);
            }
            if (!level.tryAddFreshEntityWithPassengers(entity)) {
                this.delay((Level)level, pos);
                return;
            }
            level.levelEvent(2004, pos, 0);
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                mob.spawnAnim();
            }
            spawned = true;
        }
        if (spawned) {
            this.delay((Level)level, pos);
        }
    }

    public boolean hasEasyNPC() {
        return this.isEasyNPC;
    }

    public UUID getEasyNPCUUID() {
        return this.easyNPCUUID;
    }

    public UUID getEasyNPCPresetUUID() {
        return this.easyNPCPresetUUID;
    }

    public void load(Level level, BlockPos blockPos, ValueInput valueInput) {
        super.load(level, blockPos, valueInput);
        this.displayEntity = null;
        TagValueOutput valueOutput = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
        this.save((ValueOutput)valueOutput);
        this.updateSpawnData(valueOutput.buildResult());
    }

    public void updateSpawnData(CompoundTag compoundTag) {
        CompoundTag spawnData;
        this.spawnDelay = SpawnerData.getDelay(compoundTag);
        this.minSpawnDelay = SpawnerData.getMinSpawnDelay(compoundTag);
        this.maxSpawnDelay = SpawnerData.getMaxSpawnDelay(compoundTag);
        this.spawnCount = SpawnerData.getSpawnCount(compoundTag);
        this.maxNearbyEntities = SpawnerData.getMaxNearbyEntities(compoundTag);
        this.requiredPlayerRange = SpawnerData.getRequiredPlayerRange(compoundTag);
        this.spawnRange = SpawnerData.getSpawnRange(compoundTag);
        this.nextSpawnData = SpawnerData.getSpawnData(compoundTag);
        this.isEasyNPC = false;
        this.easyNPCUUID = null;
        this.easyNPCPresetUUID = null;
        if (SpawnerData.hasSpawnData(compoundTag) && (spawnData = compoundTag.getCompoundOrEmpty("SpawnData")).contains("entity")) {
            CompoundTag entityData = spawnData.getCompoundOrEmpty("entity");
            if (entityData.contains("id")) {
                ResourceLocation entityId = ResourceLocation.tryParse((String)entityData.getString("id").orElse(""));
                boolean bl = this.isEasyNPC = entityId != null && entityId.getNamespace().equals("easy_npc");
            }
            if (entityData.contains("UUID")) {
                this.easyNPCUUID = CompoundTagUtils.readUUID(entityData);
            }
            if (entityData.contains("PresetUUID")) {
                this.easyNPCPresetUUID = CompoundTagUtils.readUUID(entityData, "PresetUUID");
            }
        }
    }

    private static /* synthetic */ Entity lambda$spawnEasyNPC$1(double finalX, double finalY, double finalZ, Entity loadedEntity) {
        loadedEntity.snapTo(finalX, finalY, finalZ, loadedEntity.getYRot(), loadedEntity.getXRot());
        return loadedEntity;
    }
}

