/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.data.spawner.SpawnerData;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SpawnerCommand
extends Command {
    private SpawnerCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"spawner").then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"parameter", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(List.of("Delay", "MinSpawnDelay", "MaxSpawnDelay", "SpawnCount", "MaxNearbyEntities", "RequiredPlayerRange", "SpawnRange"), (SuggestionsBuilder)builder)).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> SpawnerCommand.setSpawnerValue((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"target"), StringArgumentType.getString((CommandContext)context, (String)"parameter"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))));
    }

    private static int setSpawnerValue(CommandSourceStack context, BlockPos blockPos, String parameter, int value) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(blockPos);
        TagValueOutput valueOutput = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            spawnerBlockEntity.getSpawner().save((ValueOutput)valueOutput);
        } else if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity spawnerBlockEntity = (EasyNPCSpawnerBlockEntity)blockEntity;
            spawnerBlockEntity.getSpawner().save((ValueOutput)valueOutput);
        } else {
            return SpawnerCommand.sendFailureMessage(context, "No valid spawner found at " + String.valueOf(blockPos));
        }
        CompoundTag compoundTag = valueOutput.buildResult();
        if (!SpawnerData.setSpawnerValue(compoundTag, parameter, (short)value)) {
            return SpawnerCommand.sendFailureMessage(context, "Invalid parameter " + parameter + " for spawner at " + String.valueOf(blockPos));
        }
        ValueInput valueInput = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.getLevel().registryAccess(), (CompoundTag)compoundTag);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            spawnerBlockEntity.getSpawner().load((Level)context.getLevel(), spawnerBlockEntity.getBlockPos(), valueInput);
            spawnerBlockEntity.setChanged();
        } else if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity spawnerBlockEntity = (EasyNPCSpawnerBlockEntity)blockEntity;
            spawnerBlockEntity.getSpawner().load((Level)context.getLevel(), spawnerBlockEntity.getBlockPos(), valueInput);
            spawnerBlockEntity.setChanged();
        }
        return SpawnerCommand.sendSuccessMessage(context, "Adjusted spawner data " + String.valueOf(compoundTag) + " for spawner at " + String.valueOf(blockPos));
    }
}

