/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.debug.DebugManager;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class DebugCommand
extends Command {
    private DebugCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"log").then(Commands.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> DebugCommand.setDebug((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"enable")))))).then(Commands.literal((String)"info").then(Commands.literal((String)"entity_types").executes(context -> DebugCommand.getEntityTypes((CommandSourceStack)context.getSource()))));
    }

    public static int setDebug(CommandSourceStack context, boolean enable) {
        if (enable) {
            DebugCommand.sendSuccessMessage(context, "\u25ba Enable debug for Easy NPC, please check debug.log for the full output.", ChatFormatting.GREEN);
            DebugCommand.sendSuccessMessage(context, "> Use '/easy_npc debug false' to disable the debug!", ChatFormatting.WHITE);
        } else {
            DebugCommand.sendSuccessMessage(context, "\u25a0 Disable debug for Easy NPC!", ChatFormatting.RED);
            DebugCommand.sendSuccessMessage(context, "> Please check the latest.log and/or debug.log for the full output.", ChatFormatting.WHITE);
        }
        DebugManager.enableDebugLevel(enable);
        return 1;
    }

    public static int getEntityTypes(CommandSourceStack context) {
        Set<EntityType<? extends Entity>> supportedEntityTypes = EntityTypeManager.getSupportedEntityTypes();
        Set<EntityType<? extends Entity>> unsupportedEntityTypes = EntityTypeManager.getUnsupportedEntityTypes();
        Set<EntityType<? extends Entity>> unknownEntityTypes = EntityTypeManager.getUnknownEntityTypes();
        DebugCommand.sendSuccessMessage(context, "\u25ba Found " + supportedEntityTypes.size() + " supported, " + unsupportedEntityTypes.size() + " unsupported and " + unknownEntityTypes.size() + " unknown entity types.", ChatFormatting.GREEN);
        DebugCommand.sendSuccessMessage(context, "> Please check the latest.log and/or debug.log for the full output.", ChatFormatting.WHITE);
        log.info("Supported entity types: {}", supportedEntityTypes);
        log.info("Unsupported entity types: {}", unsupportedEntityTypes);
        log.info("Unknown entity types: {}", unknownEntityTypes);
        return 1;
    }
}

