/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.CatRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.CatRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class CatRawRenderer
extends CatRenderer
implements EasyNPCEntityRenderer {
    protected static final Map<CatRaw.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(CatRaw.VariantType.class), map -> {
        map.put(CatRaw.VariantType.ALL_BLACK, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/all_black.png"));
        map.put(CatRaw.VariantType.BLACK, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/black.png"));
        map.put(CatRaw.VariantType.BRITISH_SHORTHAIR, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/british_shorthair.png"));
        map.put(CatRaw.VariantType.CALICO, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/calico.png"));
        map.put(CatRaw.VariantType.JELLIE, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/jellie.png"));
        map.put(CatRaw.VariantType.OCELOT, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/ocelot.png"));
        map.put(CatRaw.VariantType.PERSIAN, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/persian.png"));
        map.put(CatRaw.VariantType.RAGDOLL, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/ragdoll.png"));
        map.put(CatRaw.VariantType.RED, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/red.png"));
        map.put(CatRaw.VariantType.SIAMESE, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/siamese.png"));
        map.put(CatRaw.VariantType.TABBY, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/tabby.png"));
        map.put(CatRaw.VariantType.WHITE, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/white.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)CatRaw.VariantType.BLACK);

    public CatRawRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(CatRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

