/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import de.markusbordihn.easynpc.client.renderer.entity.standard.PlayerRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.HumanoidSlimNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.resources.ResourceLocation;

public class PlayerSlimRenderer
extends PlayerRenderer {
    protected static final Map<HumanoidSlimNPC.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(HumanoidSlimNPC.VariantType.class), map -> {
        map.put(HumanoidSlimNPC.VariantType.ALEX, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/alex.png"));
        map.put(HumanoidSlimNPC.VariantType.ARI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/ari.png"));
        map.put(HumanoidSlimNPC.VariantType.EFE, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/efe.png"));
        map.put(HumanoidSlimNPC.VariantType.KAI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/kai.png"));
        map.put(HumanoidSlimNPC.VariantType.MAKENA, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/makena.png"));
        map.put(HumanoidSlimNPC.VariantType.NOOR, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/noor.png"));
        map.put(HumanoidSlimNPC.VariantType.STEVE, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/steve.png"));
        map.put(HumanoidSlimNPC.VariantType.SUNNY, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/sunny.png"));
        map.put(HumanoidSlimNPC.VariantType.ZURI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/zuri.png"));
        map.put(HumanoidSlimNPC.VariantType.KAWORRU, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid_slim/kaworru.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)HumanoidSlimNPC.VariantType.ALEX);

    public PlayerSlimRenderer(EntityRendererProvider.Context context) {
        super(context, true);
    }

    @Override
    public ResourceLocation getTextureLocation(PlayerRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityPlayerTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

