/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.screen;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record ScreenData(UUID uuid, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, int pageIndex, CompoundTag additionalData) {
    public static final String SCREEN_DATA_ACTION_DATA_ENTRY_ID_TAG = "ActionDataEntryId";
    public static final String SCREEN_DATA_ADDITIONAL_DATA_TAG = "AdditionalData";
    public static final String SCREEN_DATA_DIALOG_BUTTON_ID_TAG = "DialogButtonId";
    public static final String SCREEN_DATA_DIALOG_ID_TAG = "DialogId";
    public static final String SCREEN_DATA_PAGE_INDEX_TAG = "PageIndex";
    public static final String SCREEN_DATA_TAG = "ScreenData";
    public static final String SCREEN_DATA_UUID_TAG = "UUID";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public ScreenData(UUID uuid, UUID dialogId) {
        this(uuid, dialogId, null, null, 0, new CompoundTag());
    }

    public static boolean hasScreenData(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.contains(SCREEN_DATA_TAG);
    }

    public static ScreenData decode(CompoundTag compoundTag) {
        if (!ScreenData.hasScreenData(compoundTag)) {
            log.error("Unable to decode screen data from compound tag: {}", (Object)compoundTag);
            return null;
        }
        CompoundTag screenDataTag = compoundTag.getCompound(SCREEN_DATA_TAG);
        UUID uuid = screenDataTag.getUUID(SCREEN_DATA_UUID_TAG);
        UUID dialogID = screenDataTag.contains(SCREEN_DATA_DIALOG_ID_TAG) ? screenDataTag.getUUID(SCREEN_DATA_DIALOG_ID_TAG) : null;
        UUID dialogButtonId = screenDataTag.contains(SCREEN_DATA_DIALOG_BUTTON_ID_TAG) ? screenDataTag.getUUID(SCREEN_DATA_DIALOG_BUTTON_ID_TAG) : null;
        UUID actionDataEntryId = screenDataTag.contains(SCREEN_DATA_ACTION_DATA_ENTRY_ID_TAG) ? screenDataTag.getUUID(SCREEN_DATA_ACTION_DATA_ENTRY_ID_TAG) : null;
        int pageIndex = screenDataTag.getInt(SCREEN_DATA_PAGE_INDEX_TAG);
        CompoundTag data = screenDataTag.contains(SCREEN_DATA_ADDITIONAL_DATA_TAG) ? screenDataTag.getCompound(SCREEN_DATA_ADDITIONAL_DATA_TAG) : new CompoundTag();
        return new ScreenData(uuid, dialogID, dialogButtonId, actionDataEntryId, pageIndex, data);
    }

    public CompoundTag encode() {
        CompoundTag screenDataTag = new CompoundTag();
        screenDataTag.putUUID(SCREEN_DATA_UUID_TAG, this.uuid);
        if (this.dialogId != null) {
            screenDataTag.putUUID(SCREEN_DATA_DIALOG_ID_TAG, this.dialogId);
        }
        if (this.dialogButtonId != null) {
            screenDataTag.putUUID(SCREEN_DATA_DIALOG_BUTTON_ID_TAG, this.dialogButtonId);
        }
        if (this.actionDataEntryId != null) {
            screenDataTag.putUUID(SCREEN_DATA_ACTION_DATA_ENTRY_ID_TAG, this.actionDataEntryId);
        }
        screenDataTag.putInt(SCREEN_DATA_PAGE_INDEX_TAG, this.pageIndex);
        if (this.additionalData != null) {
            screenDataTag.put(SCREEN_DATA_ADDITIONAL_DATA_TAG, (Tag)this.additionalData);
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put(SCREEN_DATA_TAG, (Tag)screenDataTag);
        return compoundTag;
    }
}

