/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelPositionDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final CustomPosition DEFAULT_MODEL_PART_POSITION = new CustomPosition(0.0f, 0.0f, 0.0f);
    public static final String EASY_NPC_DATA_MODEL_POSITION_TAG = "Position";
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<ModelPartType, CustomPosition>> MODEL_PART_POSITION_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Map<ModelPartType, CustomPosition>>(){

        public Map<ModelPartType, CustomPosition> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            CompoundTag compoundTag = registryFriendlyByteBuf.readNbt();
            EnumMap<ModelPartType, CustomPosition> modelPartMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
            for (String key : compoundTag.getAllKeys()) {
                ModelPartType modelPartType = ModelPartType.get(key);
                if (modelPartType == null) continue;
                modelPartMap.put(modelPartType, new CustomPosition(modelPartType, compoundTag));
            }
            return modelPartMap;
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, Map<ModelPartType, CustomPosition> modelPartMap) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<ModelPartType, CustomPosition> entry : modelPartMap.entrySet()) {
                compoundTag.put(entry.getKey().getTagName(), (Tag)entry.getValue().save());
            }
            registryFriendlyByteBuf.writeNbt((Tag)compoundTag);
        }
    };

    public static void registerSyncedModelPositionData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("Registering Synched Model Position Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_POSITION, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.MODEL_PART_POSITION));
    }

    default public EnumMap<ModelPartType, CustomPosition> getModelPartPosition() {
        EnumMap<ModelPartType, CustomPosition> modelPartMap = (EnumMap<ModelPartType, CustomPosition>)this.getSynchedEntityData(SynchedDataIndex.MODEL_POSITION);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
            this.setModelPartPosition(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartPosition(EnumMap<ModelPartType, CustomPosition> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_POSITION, modelPartMap, true);
        }
    }

    default public void setModelPartPosition(ModelPartType modelPartType, CustomPosition Position) {
        EnumMap<ModelPartType, CustomPosition> modelPartMap = this.getModelPartPosition();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, Position);
            this.setModelPartPosition(new EnumMap<ModelPartType, CustomPosition>(modelPartMap));
        }
    }

    default public CustomPosition getModelPartPosition(ModelPartType modelPartType) {
        EnumMap<ModelPartType, CustomPosition> modelPartMap = this.getModelPartPosition();
        return modelPartMap.getOrDefault((Object)modelPartType, DEFAULT_MODEL_PART_POSITION);
    }

    default public boolean hasChangedModelPosition() {
        EnumMap<ModelPartType, CustomPosition> modelPartMap = this.getModelPartPosition();
        for (Map.Entry<ModelPartType, CustomPosition> entry : modelPartMap.entrySet()) {
            if (!entry.getValue().hasChanged()) continue;
            return true;
        }
        return false;
    }

    default public void defineSynchedModelPositionData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_POSITION, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelPositionData(CompoundTag compoundTag) {
        CompoundTag positionsTag = new CompoundTag();
        EnumMap<ModelPartType, CustomPosition> modelPartMap = this.getModelPartPosition();
        for (Map.Entry<ModelPartType, CustomPosition> entry : modelPartMap.entrySet()) {
            positionsTag.put(entry.getKey().getTagName(), (Tag)entry.getValue().save());
        }
        compoundTag.put(EASY_NPC_DATA_MODEL_POSITION_TAG, (Tag)positionsTag);
    }

    default public void readAdditionalModelPositionData(CompoundTag compoundTag) {
        if (!compoundTag.contains(EASY_NPC_DATA_MODEL_POSITION_TAG)) {
            return;
        }
        CompoundTag positionTag = compoundTag.getCompound(EASY_NPC_DATA_MODEL_POSITION_TAG);
        EnumMap<ModelPartType, CustomPosition> modelPartMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
        for (String key : positionTag.getAllKeys()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, new CustomPosition(modelPartType, positionTag));
        }
        this.setModelPartPosition(modelPartMap);
    }
}

