/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.access;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccessManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private AccessManager() {
    }

    public static boolean hasAccess(CommandSourceStack context, UUID uuid) {
        if (context == null || uuid == null) {
            return false;
        }
        try {
            ServerPlayer serverPlayer = context.m_81375_();
            boolean hasAccess = AccessManager.hasAccess(serverPlayer, uuid);
            if (hasAccess) {
                log.debug("[Access allowed] Player {} has access to EasyNPC with UUID {}!", (Object)serverPlayer, (Object)uuid);
            } else {
                log.error("[Access denied] Player {} tried to access EasyNPC with UUID {}!", (Object)serverPlayer, (Object)uuid);
            }
            return hasAccess;
        }
        catch (CommandSyntaxException serverPlayerException) {
            try {
                EasyNPC easyNPCEntity;
                Entity entity = context.m_81374_();
                EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, context.m_81372_());
                if (easyNPC != null && easyNPC.getEntity() == entity) {
                    log.debug("[Access allowed] EasyNPC {} and entity {} are the same!", easyNPC, (Object)entity);
                    return true;
                }
                if (easyNPC != null && easyNPC.getEasyNPCOwnerData() != null && entity instanceof EasyNPC && (easyNPCEntity = (EasyNPC)entity).getEasyNPCOwnerData() != null) {
                    boolean ownerDataAccess;
                    OwnerDataCapable ownerData = easyNPC.getEasyNPCOwnerData();
                    OwnerDataCapable ownerDataEntity = easyNPCEntity.getEasyNPCOwnerData();
                    boolean bl = ownerDataAccess = !ownerData.hasNPCOwner() && !ownerDataEntity.hasNPCOwner() || ownerData.m_269323_() != null && ownerData.m_269323_().equals((Object)ownerDataEntity.m_269323_());
                    if (ownerDataAccess) {
                        log.debug("[Access allowed] EasyNPC {} and entity {} has same owner data!", easyNPC, (Object)easyNPCEntity);
                    } else {
                        log.error("[Access denied] EasyNPC {} and entity {} has different owner data!", easyNPC, (Object)easyNPCEntity);
                    }
                    return ownerDataAccess;
                }
                log.error("[Access denied] Entity {} tried to access EasyNPC {} with UUID {}!", (Object)entity, easyNPC, (Object)uuid);
                return false;
            }
            catch (CommandSyntaxException entityException) {
                log.debug("[Access skipped] EasyNPC with UUID {} was not executed by a player or entity!", (Object)uuid);
                return true;
            }
        }
    }

    public static boolean hasAccess(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        return AccessManager.getEasyNPCEntityByUUID(easyNPC.getEntityUUID(), serverPlayer) != null;
    }

    public static boolean hasAccess(ServerPlayer serverPlayer, UUID uuid) {
        return AccessManager.getEasyNPCEntityByUUID(uuid, serverPlayer) != null;
    }

    public static EasyNPC<?> getEasyNPCEntityByUUID(UUID uuid, ServerPlayer serverPlayer) {
        if (serverPlayer == null || uuid == null) {
            return null;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("[{}:{}] Unable to get valid entity!", (Object)uuid, (Object)serverPlayer);
            return null;
        }
        if (!serverPlayer.m_7500_() && !easyNPC.getEasyNPCOwnerData().isNPCOwner(serverPlayer) && serverPlayer.m_20194_() != null && serverPlayer.m_20194_().m_129944_(serverPlayer.m_36316_()) < 2) {
            log.error("[{}:{}] Player has no permission to access {}!", (Object)uuid, (Object)serverPlayer, easyNPC);
            return null;
        }
        return easyNPC;
    }
}

