/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.dialog;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.Screen;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogMetaData;
import de.markusbordihn.easynpc.data.dialog.DialogScreenLayout;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.menu.dialog.DialogMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.screen.render.EntityScreenRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class DialogScreen<T extends DialogMenu>
extends Screen<T> {
    private static final int BUTTON_WIDTH = 126;
    private static final int MIDDLE_BUTTON_WIDTH = 200;
    private static final int LARGE_BUTTON_WIDTH = 250;
    private static final int MAX_NUMBER_OF_PIXEL_PER_LINE = 180;
    private static final int MAX_NUMBER_OF_DIALOG_LINES = 10;
    private static final int MAX_TOTAL_DIALOG_LINES = 100;
    private static DialogScreenLayout dialogScreenLayout = DialogScreenLayout.UNKNOWN;
    protected final ArrayList<Button> dialogButtons = new ArrayList();
    protected final Component dialogText;
    protected final DialogMetaData dialogMetaData;
    protected Button dialogForwardButton = null;
    protected Button dialogBackwardButton = null;
    protected String dialog;
    protected Component dialogComponent;
    protected int numberOfDialogLines = 1;
    protected int dialogPageIndex = 0;
    private List<FormattedCharSequence> cachedDialogComponents = Collections.emptyList();

    public DialogScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component, 280, 200);
        this.dialogText = this.getDialogText();
        this.dialogMetaData = new DialogMetaData(this.getEasyNPC().getLivingEntity(), (Player)(this.minecraftInstance != null ? this.minecraftInstance.f_91074_ : null));
    }

    private static void setDialogScreenLayout(DialogScreenLayout dialogScreenLayout) {
        DialogScreen.dialogScreenLayout = dialogScreenLayout;
    }

    protected void renderDialog(GuiGraphics guiGraphics) {
        int dialogTopPosition = this.topPos + 20;
        switch (dialogScreenLayout) {
            case COMPACT_TEXT_ONLY: 
            case COMPACT_TEXT_WITH_ONE_BUTTON: 
            case COMPACT_TEXT_WITH_TWO_BUTTONS: 
            case COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS: 
            case COMPACT_TEXT_WITH_THREE_BUTTONS: 
            case COMPACT_TEXT_WITH_FOUR_BUTTONS: 
            case COMPACT_TEXT_WITH_FIVE_BUTTONS: 
            case COMPACT_TEXT_WITH_SIX_BUTTONS: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DIALOG, this.leftPos + 70, dialogTopPosition, 0, 120, 205, 78);
                break;
            }
            default: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DIALOG, this.leftPos + 70, dialogTopPosition, 0, 0, 205, 118);
            }
        }
        if (!this.cachedDialogComponents.isEmpty()) {
            for (int line = this.dialogPageIndex * 10; line < this.numberOfDialogLines && line < 10 * (this.dialogPageIndex + 1); ++line) {
                Objects.requireNonNull(this.f_96547_);
                int textTopPosition = dialogTopPosition + 6 + (line - this.dialogPageIndex * 10) * (9 + 2);
                FormattedCharSequence formattedCharSequence = this.cachedDialogComponents.get(line);
                Text.drawString(guiGraphics, this.f_96547_, formattedCharSequence, this.leftPos + 87, textTopPosition, 0);
            }
        }
    }

    private void setDialogText(DialogDataEntry dialogData) {
        if (dialogData == null) {
            return;
        }
        String dialogText = dialogData.getDialogText(this.dialogMetaData);
        if (dialogText == null || dialogText.isBlank()) {
            return;
        }
        this.dialogComponent = TextComponent.getText(dialogText);
        this.cachedDialogComponents = this.f_96547_.m_92923_((FormattedText)this.dialogComponent, 180);
        this.numberOfDialogLines = Math.min(100, this.cachedDialogComponents.size());
    }

    private void addDialogButton(DialogButtonEntry dialogButtonEntry) {
        if (dialogButtonEntry == null) {
            return;
        }
        int dialogButtonMaxTextLength = switch (dialogScreenLayout) {
            case DialogScreenLayout.COMPACT_TEXT_WITH_ONE_BUTTON, DialogScreenLayout.COMPACT_TEXT_WITH_THREE_BUTTONS, DialogScreenLayout.TEXT_WITH_ONE_BUTTON, DialogScreenLayout.TEXT_WITH_TWO_BUTTONS, DialogScreenLayout.TEXT_WITH_THREE_BUTTONS -> 41;
            case DialogScreenLayout.COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS -> 32;
            default -> 22;
        };
        TextButton dialogButton = new TextButton(this.leftPos + 70, this.topPos + 55, 198, dialogButtonEntry.getButtonName(dialogButtonMaxTextLength), onPress -> {
            if (this.getActionEventSet().hasActionEvent(ActionEventType.ON_BUTTON_CLICK)) {
                NetworkMessageHandlerManager.getServerHandler().executeActionEvent(this.getEasyNPCUUID(), ActionEventType.ON_BUTTON_CLICK);
            }
            if (dialogButtonEntry.hasActionData()) {
                UUID buttonId = dialogButtonEntry.id();
                NetworkMessageHandlerManager.getServerHandler().executeDialogButtonAction(this.getEasyNPCUUID(), this.getDialogUUID(), buttonId);
            } else {
                this.closeScreen();
            }
        });
        dialogButton.f_93624_ = dialogButtonEntry.name() != null && !dialogButtonEntry.name().isBlank();
        this.dialogButtons.add(dialogButton);
    }

    private Button renderDialogButton(int buttonIndex, int width, int left, int top) {
        Button dialogButton = this.dialogButtons.get(buttonIndex);
        dialogButton.m_93674_(width);
        dialogButton.m_252865_(left);
        dialogButton.m_253211_(top);
        return (Button)this.m_142416_((GuiEventListener)dialogButton);
    }

    private void renderDialogButtons() {
        switch (dialogScreenLayout) {
            case COMPACT_TEXT_ONLY: 
            case TEXT_ONLY: {
                break;
            }
            case COMPACT_TEXT_WITH_ONE_BUTTON: {
                this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 140);
                break;
            }
            case COMPACT_TEXT_WITH_TWO_BUTTONS: {
                Button firstCompactDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 140);
                this.renderDialogButton(1, 126, firstCompactDialogButton.m_252754_() + firstCompactDialogButton.m_5711_() + 10, firstCompactDialogButton.m_252907_());
                break;
            }
            case COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS: {
                Button firstCompactLargeDialogButton = this.renderDialogButton(0, 200, this.leftPos + 75, this.topPos + 115);
                this.renderDialogButton(1, 200, firstCompactLargeDialogButton.m_252754_(), firstCompactLargeDialogButton.m_252907_() + firstCompactLargeDialogButton.m_93694_() + 10);
                break;
            }
            case TEXT_WITH_ONE_BUTTON: {
                this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 170);
                break;
            }
            case TEXT_WITH_TWO_BUTTONS: {
                Button firstTwoDialogButton = this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 145);
                this.renderDialogButton(1, 250, firstTwoDialogButton.m_252754_(), firstTwoDialogButton.m_252907_() + firstTwoDialogButton.m_93694_() + 10);
                break;
            }
            case COMPACT_TEXT_WITH_THREE_BUTTONS: 
            case TEXT_WITH_THREE_BUTTONS: {
                Button firstThreeDialogButton = this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 140);
                Button secondThreeDialogButton = this.renderDialogButton(1, 250, firstThreeDialogButton.m_252754_(), firstThreeDialogButton.m_252907_() + firstThreeDialogButton.m_93694_() + 5);
                this.renderDialogButton(2, 250, secondThreeDialogButton.m_252754_(), secondThreeDialogButton.m_252907_() + secondThreeDialogButton.m_93694_() + 5);
                break;
            }
            case COMPACT_TEXT_WITH_FOUR_BUTTONS: 
            case TEXT_WITH_FOUR_BUTTONS: {
                Button firstFourDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 150);
                Button secondFourDialogButton = this.renderDialogButton(1, 126, firstFourDialogButton.m_252754_() + firstFourDialogButton.m_5711_() + 10, firstFourDialogButton.m_252907_());
                Button thirdFourDialogButton = this.renderDialogButton(2, 126, firstFourDialogButton.m_252754_(), firstFourDialogButton.m_252907_() + firstFourDialogButton.m_93694_() + 10);
                this.renderDialogButton(3, 126, secondFourDialogButton.m_252754_(), thirdFourDialogButton.m_252907_());
                break;
            }
            case COMPACT_TEXT_WITH_FIVE_BUTTONS: 
            case TEXT_WITH_FIVE_BUTTONS: {
                Button firstFiveDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 140);
                Button secondFiveDialogButton = this.renderDialogButton(1, 126, firstFiveDialogButton.m_252754_() + firstFiveDialogButton.m_5711_() + 10, firstFiveDialogButton.m_252907_());
                Button thirdFiveDialogButton = this.renderDialogButton(2, 126, firstFiveDialogButton.m_252754_(), firstFiveDialogButton.m_252907_() + firstFiveDialogButton.m_93694_() + 5);
                this.renderDialogButton(3, 126, secondFiveDialogButton.m_252754_(), thirdFiveDialogButton.m_252907_());
                this.renderDialogButton(4, 126, firstFiveDialogButton.m_252754_(), thirdFiveDialogButton.m_252907_() + thirdFiveDialogButton.m_93694_() + 5);
                break;
            }
            case COMPACT_TEXT_WITH_SIX_BUTTONS: 
            case TEXT_WITH_SIX_BUTTONS: {
                Button firstSixDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 140);
                Button secondSixDialogButton = this.renderDialogButton(1, 126, firstSixDialogButton.m_252754_() + firstSixDialogButton.m_5711_() + 10, firstSixDialogButton.m_252907_());
                Button thirdSixDialogButton = this.renderDialogButton(2, 126, firstSixDialogButton.m_252754_(), firstSixDialogButton.m_252907_() + firstSixDialogButton.m_93694_() + 5);
                this.renderDialogButton(3, 126, secondSixDialogButton.m_252754_(), thirdSixDialogButton.m_252907_());
                Button fifthSixDialogButton = this.renderDialogButton(4, 126, firstSixDialogButton.m_252754_(), thirdSixDialogButton.m_252907_() + thirdSixDialogButton.m_93694_() + 5);
                this.renderDialogButton(5, 126, secondSixDialogButton.m_252754_(), fifthSixDialogButton.m_252907_());
                break;
            }
            default: {
                log.warn("Unknown dialog screen layout {} for {} with {} line(s)", (Object)dialogScreenLayout, (Object)this.getDialogDataSet(), (Object)this.numberOfDialogLines);
            }
        }
    }

    private void defineDialogNavigationButtons() {
        int dialogNavigationButtonTopPosition = dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_ONLY || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_ONE_BUTTON || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_TWO_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_THREE_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_FOUR_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_FIVE_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_SIX_BUTTONS ? this.topPos + 95 : this.topPos + 136;
        this.dialogForwardButton = (Button)this.m_142416_((GuiEventListener)new SpriteButton(this.leftPos + 257, dialogNavigationButtonTopPosition, 12, 12, Constants.TEXTURE_DIALOG, 206, 2, 12, 12, onPress -> {
            int n = this.dialogPageIndex = this.dialogPageIndex < this.numberOfDialogLines / 10 ? this.dialogPageIndex + 1 : 0;
            if (this.dialogBackwardButton != null) {
                boolean bl = this.dialogBackwardButton.f_93623_ = this.dialogPageIndex > 0;
            }
            if (this.dialogForwardButton != null) {
                this.dialogForwardButton.f_93623_ = this.dialogPageIndex < this.numberOfDialogLines / 10;
            }
        }));
        this.dialogForwardButton.f_93623_ = this.dialogPageIndex < this.numberOfDialogLines / 10;
        this.dialogBackwardButton = (Button)this.m_142416_((GuiEventListener)new SpriteButton(this.leftPos + 245, dialogNavigationButtonTopPosition, 12, 12, Constants.TEXTURE_DIALOG, 207, 28, 12, 12, onPress -> {
            int n = this.dialogPageIndex = this.dialogPageIndex > 0 ? this.dialogPageIndex - 1 : this.numberOfDialogLines / 10;
            if (this.dialogForwardButton != null) {
                boolean bl = this.dialogForwardButton.f_93623_ = this.dialogPageIndex < this.numberOfDialogLines / 10;
            }
            if (this.dialogBackwardButton != null) {
                this.dialogBackwardButton.f_93623_ = this.dialogPageIndex > 0;
            }
        }));
        this.dialogBackwardButton.f_93623_ = this.dialogPageIndex > 0;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.titleLabelX = 10;
        this.titleLabelY = 8;
        this.closeButton.m_252865_(this.leftPos + this.imageWidth - 13);
        this.closeButton.m_253211_(this.topPos + 4);
        DialogScreen.setDialogScreenLayout(DialogUtils.getDialogScreenLayout(this.getDialogData(), this.f_96547_));
        log.debug("Prepare Dialog Screen {} with page index {} for {} with {} line(s) and layout {}", (Object)this.getDialogUUID(), (Object)this.getPageIndex(), (Object)this.getDialogDataSet(), (Object)this.numberOfDialogLines, (Object)dialogScreenLayout);
        this.setDialogText(this.getDialogData());
        log.debug("Dialog with {} line(s) and layout {}", (Object)this.numberOfDialogLines, (Object)dialogScreenLayout);
        if (this.numberOfDialogLines > 10) {
            this.defineDialogNavigationButtons();
        }
        if (this.getActionEventSet().hasActionEvent(ActionEventType.ON_OPEN_DIALOG)) {
            NetworkMessageHandlerManager.getServerHandler().executeActionEvent(this.getEasyNPCUUID(), ActionEventType.ON_OPEN_DIALOG);
        }
        if (this.hasDialogData() && this.getDialogData().getNumberOfDialogButtons() > 0) {
            this.dialogButtons.ensureCapacity(this.getDialogData().getNumberOfDialogButtons());
            for (DialogButtonEntry dialogButtonEntry : this.getDialogData().getDialogButtons()) {
                if (dialogButtonEntry == null) continue;
                this.addDialogButton(dialogButtonEntry);
            }
            this.renderDialogButtons();
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        if (this.getEasyNPC() == null) {
            return;
        }
        super.m_88315_(guiGraphics, x, y, partialTicks);
        int avatarPositionTop = 60 + this.getEasyNPC().getEasyNPCDialogData().getEntityDialogTop();
        int left = this.leftPos + 40;
        int top = this.topPos + 70 + avatarPositionTop;
        int scale = this.getEasyNPC().getEasyNPCDialogData().getEntityDialogScaling();
        float rotationYaw = Math.round((double)(left - 140) - (double)this.xMouse * 0.25);
        float rotationPitch = Math.round((double)(top - 120) - (double)this.yMouse * 0.5);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
        EntityRenderConfig config = EntityRenderConfig.dialog(left, top, scale, rotationYaw, rotationPitch);
        EntityScreenRenderer.renderEntity(guiGraphics, this.getEasyNPC(), config);
        guiGraphics.m_280168_().m_85849_();
        this.renderDialog(guiGraphics);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        Text.drawString(guiGraphics, this.f_96547_, this.f_96539_, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        switch (dialogScreenLayout) {
            case UNKNOWN: {
                break;
            }
            case COMPACT_TEXT_ONLY: 
            case COMPACT_TEXT_WITH_ONE_BUTTON: 
            case COMPACT_TEXT_WITH_TWO_BUTTONS: 
            case COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos, 0, 0, 200, 170);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 200, this.topPos, 165, 0, 85, 170);
                break;
            }
            default: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos, 0, 0, 210, 140);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 200, this.topPos, 165, 0, 85, 140);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos + 70, 0, 30, 210, 140);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 200, this.topPos + 70, 165, 30, 85, 140);
            }
        }
    }

    @Override
    public void m_7379_() {
        if (this.getActionEventSet().hasActionEvent(ActionEventType.ON_CLOSE_DIALOG)) {
            NetworkMessageHandlerManager.getServerHandler().executeActionEvent(this.getEasyNPCUUID(), ActionEventType.ON_CLOSE_DIALOG);
        }
        super.m_7379_();
    }
}

