/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelRotationDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final CustomRotation DEFAULT_MODEL_PART_ROTATION = new CustomRotation(0.0f, 0.0f, 0.0f);
    public static final String EASY_NPC_DATA_MODEL_ROTATION_TAG = "Rotation";

    public static void registerSynchedModelRotationData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("Registering Synched Model Rotation Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_ROTATION, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.MODEL_PART_ROTATION));
    }

    default public EnumMap<ModelPartType, CustomRotation> getModelPartRotation() {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = (EnumMap<ModelPartType, CustomRotation>)this.getSynchedEntityData(SynchedDataIndex.MODEL_ROTATION);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
            this.setModelPartRotation(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartRotation(EnumMap<ModelPartType, CustomRotation> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_ROTATION, modelPartMap, true);
        }
    }

    default public void setModelPartRotation(ModelPartType modelPartType, CustomRotation rotation) {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, rotation);
            this.setModelPartRotation(new EnumMap<ModelPartType, CustomRotation>(modelPartMap));
        }
    }

    default public CustomRotation getModelPartRotation(ModelPartType modelPartType) {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        return modelPartMap.getOrDefault((Object)modelPartType, DEFAULT_MODEL_PART_ROTATION);
    }

    default public void setModelRotation(float y) {
        CustomRotation rotation = this.getModelPartRotation(ModelPartType.ROOT);
        this.setModelRotation(rotation.x(), y, rotation.z());
    }

    default public void setModelRotation(float x, float y, float z) {
        LivingEntity livingEntity;
        Entity entity = this.getEntity();
        if (entity != null) {
            entity.m_146922_(y);
            entity.m_5618_(y);
            entity.m_5616_(y);
            entity.f_19859_ = y;
        }
        if ((livingEntity = this.getLivingEntity()) != null) {
            livingEntity.f_20884_ = y;
            livingEntity.f_20886_ = y;
        }
        this.setModelPartRotation(ModelPartType.ROOT, new CustomRotation(x, y, z).withLocked(y != 0.0f));
    }

    default public boolean hasChangedModelRotation() {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        for (CustomRotation rotation : modelPartMap.values()) {
            if (!rotation.hasChanged() || rotation == modelPartMap.get((Object)ModelPartType.ROOT) && rotation.hasChangedYaw()) continue;
            return true;
        }
        return false;
    }

    default public void defineSynchedModelRotationData() {
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_ROTATION, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelRotationData(CompoundTag compoundTag) {
        CompoundTag rotationsTag = new CompoundTag();
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        for (Map.Entry<ModelPartType, CustomRotation> entry : modelPartMap.entrySet()) {
            rotationsTag.m_128365_(entry.getKey().getTagName(), (Tag)entry.getValue().save());
        }
        compoundTag.m_128365_(EASY_NPC_DATA_MODEL_ROTATION_TAG, (Tag)rotationsTag);
    }

    default public void readAdditionalModelRotationData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(EASY_NPC_DATA_MODEL_ROTATION_TAG)) {
            return;
        }
        CompoundTag rotationsTag = compoundTag.m_128469_(EASY_NPC_DATA_MODEL_ROTATION_TAG);
        EnumMap<ModelPartType, CustomRotation> modelPartMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
        for (String key : rotationsTag.m_128431_()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, new CustomRotation(modelPartType, rotationsTag));
        }
        this.setModelPartRotation(modelPartMap);
    }
}

