/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.SkeletonRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SkeletonNPC
extends SkeletonRaw
implements StandardEasyNPC<SkeletonRaw> {
    public static final String ID = "skeleton";
    public static final String ID_STRAY = "skeleton_stray";
    public static final String ID_WITHER_SKELETON = "wither_skeleton";

    public SkeletonNPC(EntityType<? extends Skeleton> entityType, Level level) {
        this(entityType, level, SkeletonRaw.VariantType.SKELETON);
    }

    public SkeletonNPC(EntityType<? extends Skeleton> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
        this.m_20331_(true);
        this.getEntityAttributes().setEnvironmentalAttributes(this.getEntityAttributes().getEnvironmentalAttributes().withCanBreathUnderwater(true));
    }

    public static AttributeSupplier.Builder m_32166_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22285_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22287_, 0.0);
    }

    @Override
    public boolean canUseArmor() {
        return true;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        SkeletonRaw.VariantType soundVariant = SkeletonRaw.VariantType.valueOf(variantName);
        switch (soundVariant) {
            case STRAY: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.f_12451_);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.f_12452_);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.f_12453_);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.f_12454_);
                break;
            }
            case WITHER_SKELETON: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.f_12559_);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.f_12560_);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.f_12561_);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.f_12562_);
                break;
            }
            default: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.f_12423_);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.f_12424_);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.f_12381_);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.f_12383_);
            }
        }
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.f_12508_);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.f_12509_);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.f_12507_);
        return soundDataSet;
    }

    protected void m_8099_() {
    }

    protected boolean m_21527_() {
        return false;
    }

    @Override
    public void m_7023_(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.m_7023_(vec3);
        } else {
            this.m_267651_(this instanceof FlyingAnimal);
        }
    }
}

