/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.screen.render;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class EntityScreenRenderer {
    private EntityScreenRenderer() {
    }

    public static void renderEntity(GuiGraphics guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config) {
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderState backupState = new EntityRenderState(livingEntity, easyNPC, config);
        EntityScreenRenderer.applyRenderModifications(easyNPC, config, backupState);
        int renderScale = config.scale();
        if (config.scissorBox() != null) {
            CustomScale originalScale;
            float multiplier = config.scissorBox().scaleMultiplier();
            renderScale = (int)((float)config.scale() * multiplier);
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null && (originalScale = modelData.getModelPartScale(ModelPartType.ROOT)) != null) {
                float adjustment = 1.0f / multiplier;
                CustomScale adjustedScale = new CustomScale(originalScale.x() * adjustment, originalScale.y() * adjustment, originalScale.z() * adjustment);
                modelData.setModelPartScale(ModelPartType.ROOT, adjustedScale);
            }
        }
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)config.x(), (int)config.y(), (int)renderScale, (float)config.rotationYaw(), (float)config.rotationPitch(), (LivingEntity)livingEntity);
        EntityScreenRenderer.restoreEntityState(easyNPC, backupState);
    }

    private static void applyRenderModifications(EasyNPC<?> easyNPC, EntityRenderConfig config, EntityRenderState backupState) {
        ProfessionDataCapable professionData;
        VariantDataCapable variantData;
        SkinDataCapable skinData;
        RenderDataCapable renderData;
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderOverrides overrides = config.overrides();
        if (overrides.invisible() != null) {
            entity.m_6842_(overrides.invisible().booleanValue());
        }
        if (overrides.hideNameTag() != null && overrides.hideNameTag().booleanValue()) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null) {
                minecraft.f_91066_.f_92062_ = true;
            } else {
                livingEntity.m_6593_(null);
                livingEntity.m_20340_(false);
            }
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (overrides.rootRotation() != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, overrides.rootRotation());
            }
            if (overrides.rootScale() != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, overrides.rootScale());
            }
            if (overrides.modelPose() != null) {
                modelData.setModelPose(overrides.modelPose());
            }
        }
        if (overrides.entityPose() != null) {
            entity.m_20124_(overrides.entityPose());
        }
        if ((renderData = easyNPC.getEasyNPCRenderData()) != null && renderData.getRenderDataSet() != null) {
            RenderDataSet renderDataSet = renderData.getRenderDataSet();
            if (overrides.renderType() != null) {
                renderDataSet.setRenderType(overrides.renderType());
            }
            if (overrides.renderEntityType() != null) {
                renderDataSet.setRenderEntityType(overrides.renderEntityType());
            }
        }
        if ((skinData = easyNPC.getEasyNPCSkinData()) != null && (overrides.skinType() != null || overrides.skinUUID() != null)) {
            SkinDataEntry currentEntry;
            SkinDataEntry modifiedEntry = currentEntry = skinData.getSkinDataEntry();
            if (overrides.skinType() != null) {
                modifiedEntry = modifiedEntry.withType(overrides.skinType());
            }
            if (overrides.skinUUID() != null) {
                modifiedEntry = modifiedEntry.withUUID(overrides.skinUUID());
            }
            skinData.setSkinDataEntry(modifiedEntry);
        }
        if ((variantData = easyNPC.getEasyNPCVariantData()) != null && overrides.variant() != null) {
            variantData.setVariantType(overrides.variant());
        }
        if ((professionData = easyNPC.getEasyNPCProfessionData()) != null && overrides.profession() != null) {
            professionData.setProfession(overrides.profession());
        }
    }

    private static void restoreEntityState(EasyNPC<?> easyNPC, EntityRenderState backupState) {
        ProfessionDataCapable professionData;
        VariantDataCapable variantData;
        SkinDataCapable skinData;
        RenderDataCapable renderData;
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        livingEntity.m_6593_(backupState.customName);
        livingEntity.m_20340_(backupState.shouldShowName);
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null) {
            minecraft.f_91066_.f_92062_ = backupState.minecraftHideGui;
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (backupState.rootRotation != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, backupState.rootRotation);
            }
            if (backupState.rootScale != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, backupState.rootScale);
            }
            if (backupState.modelPose != null) {
                modelData.setModelPose(backupState.modelPose);
            }
        }
        if (backupState.entityPose != null) {
            entity.m_20124_(backupState.entityPose);
        }
        if ((renderData = easyNPC.getEasyNPCRenderData()) != null && renderData.getRenderDataSet() != null && backupState.renderDataSet != null) {
            if (backupState.renderType != null) {
                renderData.getRenderDataSet().setRenderType(backupState.renderType);
            }
            if (backupState.renderEntityType != null) {
                renderData.getRenderDataSet().setRenderEntityType(backupState.renderEntityType);
            }
        }
        if ((skinData = easyNPC.getEasyNPCSkinData()) != null && backupState.skinDataEntry != null) {
            skinData.setSkinDataEntry(backupState.skinDataEntry);
        }
        if ((variantData = easyNPC.getEasyNPCVariantData()) != null && backupState.variantType != null) {
            variantData.setVariantType(backupState.variantType);
        }
        if ((professionData = easyNPC.getEasyNPCProfessionData()) != null && backupState.profession != null) {
            professionData.setProfession(backupState.profession);
        }
    }

    private static class EntityRenderState {
        final Component customName;
        final boolean shouldShowName;
        final boolean minecraftHideGui;
        final CustomRotation rootRotation;
        final CustomScale rootScale;
        final ModelPose modelPose;
        final Pose entityPose;
        final RenderDataSet renderDataSet;
        final RenderType renderType;
        final EntityType<?> renderEntityType;
        final SkinDataEntry skinDataEntry;
        final Enum<?> variantType;
        final Profession profession;

        EntityRenderState(LivingEntity livingEntity, EasyNPC<?> easyNPC, EntityRenderConfig config) {
            this.customName = livingEntity.m_7770_();
            this.shouldShowName = livingEntity.m_6052_();
            Minecraft minecraft = Minecraft.m_91087_();
            this.minecraftHideGui = minecraft != null ? minecraft.f_91066_.f_92062_ : false;
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null) {
                this.rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
                this.rootScale = modelData.getModelPartScale(ModelPartType.ROOT);
                this.modelPose = modelData.getModelPose();
            } else {
                this.rootRotation = null;
                this.rootScale = null;
                this.modelPose = null;
            }
            this.entityPose = easyNPC.getEntity().m_20089_();
            RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
            if (renderData != null && renderData.getRenderDataSet() != null) {
                this.renderDataSet = renderData.getRenderDataSet();
                this.renderType = renderData.getRenderDataSet().getRenderType();
                this.renderEntityType = renderData.getRenderDataSet().getRenderEntityType();
            } else {
                this.renderDataSet = null;
                this.renderType = null;
                this.renderEntityType = null;
            }
            SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
            this.skinDataEntry = skinData != null ? skinData.getSkinDataEntry() : null;
            VariantDataCapable variantData = easyNPC.getEasyNPCVariantData();
            this.variantType = variantData != null ? variantData.getVariantType() : null;
            ProfessionDataCapable professionData = easyNPC.getEasyNPCProfessionData();
            this.profession = professionData != null ? professionData.getProfession() : null;
        }
    }
}

