/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface NetworkHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    public static final String LOG_PREFIX = "[NetworkHandler]";
    public static final int PROTOCOL_VERSION = 23;

    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(class_2960 var1, Class<M> var2, Function<class_2540, M> var3);

    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(class_2960 var1, Class<M> var2, Function<class_2540, M> var3);

    public <M extends NetworkMessageRecord> void sendToServer(M var1);

    public <M extends NetworkMessageRecord> void sendToPlayer(M var1, class_3222 var2);

    public <M extends NetworkMessageRecord> void addClientMessage(class_2960 var1, Class<M> var2);

    public <M extends NetworkMessageRecord> void addServerMessage(class_2960 var1, Class<M> var2);

    public Map<class_2960, Class<? extends NetworkMessageRecord>> getClientMessages();

    public Map<class_2960, Class<? extends NetworkMessageRecord>> getServerMessages();

    public <M extends NetworkMessageRecord> void addRegisteredClientMessage(class_2960 var1, Class<M> var2);

    public <M extends NetworkMessageRecord> void addRegisteredServerMessage(class_2960 var1, Class<M> var2);

    public Map<class_2960, Class<? extends NetworkMessageRecord>> getRegisteredClientMessages();

    public Map<class_2960, Class<? extends NetworkMessageRecord>> getRegisteredServerMessages();

    default public boolean sendMessageToPlayer(NetworkMessageRecord networkMessageRecord, class_3222 serverPlayer) {
        if (!this.hasClientMessage(networkMessageRecord.id())) {
            log.error("{} Message {} is not registered as client message", (Object)LOG_PREFIX, (Object)networkMessageRecord.id());
            return false;
        }
        try {
            this.sendToPlayer(networkMessageRecord, serverPlayer);
        }
        catch (Exception e) {
            log.error("{} Failed to send message {} to player {}", (Object)LOG_PREFIX, (Object)networkMessageRecord.id(), (Object)serverPlayer.method_5477().getString(), (Object)e);
            return false;
        }
        return true;
    }

    default public boolean sendMessageToServer(NetworkMessageRecord networkMessageRecord) {
        if (!this.hasServerMessage(networkMessageRecord.id())) {
            log.error("{} Message {} is not registered as server message", (Object)LOG_PREFIX, (Object)networkMessageRecord.id());
            return false;
        }
        if (class_310.method_1551().method_1562() == null) {
            log.error("{} Failed to send message {} to server: No connection available", (Object)LOG_PREFIX, (Object)networkMessageRecord.id());
            return false;
        }
        try {
            this.sendToServer(networkMessageRecord);
        }
        catch (Exception e) {
            log.error("{} Failed to send message {} to server", (Object)LOG_PREFIX, (Object)networkMessageRecord.id(), (Object)e);
            return false;
        }
        return true;
    }

    default public boolean hasClientMessage(class_2960 messageID) {
        return this.getClientMessages().containsKey(messageID);
    }

    default public boolean hasServerMessage(class_2960 messageID) {
        return this.getServerMessages().containsKey(messageID);
    }

    default public Class<? extends NetworkMessageRecord> getRegisteredClientMessage(class_2960 messageID) {
        return this.getRegisteredClientMessages().get(messageID);
    }

    default public Class<? extends NetworkMessageRecord> getRegisteredServerMessage(class_2960 messageID) {
        return this.getRegisteredServerMessages().get(messageID);
    }

    default public class_2960 getRegisteredClientMessageId(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredClientMessages().entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(networkMessage)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    default public class_2960 getRegisteredServerMessageId(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredServerMessages().entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(networkMessage)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    default public boolean hasRegisteredClientMessage(class_2960 messageID) {
        return this.getRegisteredClientMessages().containsKey(messageID);
    }

    default public boolean hasRegisteredClientMessage(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredClientMessages().containsValue(networkMessage);
    }

    default public boolean hasRegisteredServerMessage(class_2960 messageID) {
        return this.getRegisteredServerMessages().containsKey(messageID);
    }

    default public boolean hasRegisteredServerMessage(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredServerMessages().containsValue(networkMessage);
    }

    default public <M extends NetworkMessageRecord> void registerServerNetworkMessage(class_2960 messageID, Class<M> networkMessage, Function<class_2540, M> creator) {
        if (NetworkHandlerManager.isServerNetworkHandler()) {
            if (this.hasRegisteredServerMessage(messageID)) {
                log.error("{} Server network message id {} already registered with {}", (Object)LOG_PREFIX, (Object)messageID, this.getRegisteredServerMessage(messageID));
                return;
            }
            if (this.hasRegisteredServerMessage(networkMessage)) {
                log.error("{} Server network message {} already registered with id {}", (Object)LOG_PREFIX, networkMessage, (Object)this.getRegisteredServerMessageId(networkMessage));
                return;
            }
            try {
                this.registerServerNetworkMessageHandler(messageID, networkMessage, creator);
                this.addRegisteredServerMessage(messageID, networkMessage);
            }
            catch (Exception e) {
                log.error("{} Failed to register server network message id {} with {}", (Object)LOG_PREFIX, (Object)messageID, networkMessage, (Object)e);
                return;
            }
        }
        this.addServerMessage(messageID, networkMessage);
    }

    default public <M extends NetworkMessageRecord> void registerClientNetworkMessage(class_2960 messageID, Class<M> networkMessage, Function<class_2540, M> creator) {
        if (NetworkHandlerManager.isClientNetworkHandler()) {
            if (this.hasRegisteredClientMessage(messageID)) {
                log.error("{} Client network message id {} already registered with {}", (Object)LOG_PREFIX, (Object)messageID, this.getRegisteredClientMessage(messageID));
                return;
            }
            if (this.hasRegisteredClientMessage(networkMessage)) {
                log.error("{} Client network message {} already registered with id {}", (Object)LOG_PREFIX, networkMessage, (Object)this.getRegisteredClientMessageId(networkMessage));
                return;
            }
            try {
                this.registerClientNetworkMessageHandler(messageID, networkMessage, creator);
                this.addRegisteredClientMessage(messageID, networkMessage);
            }
            catch (Exception e) {
                log.error("{} Failed to register client network message id {} with {}", (Object)LOG_PREFIX, (Object)messageID, networkMessage, (Object)e);
                return;
            }
        }
        this.addClientMessage(messageID, networkMessage);
    }

    default public void logRegisterClientNetworkMessageHandler(class_2960 messageID, Class<?> networkMessage) {
        log.info("{} Registering client network message {} with {}", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), (Object)messageID);
    }

    default public void logRegisterClientNetworkMessageHandler(class_2960 messageID, Class<?> networkMessage, int registrationID) {
        log.info("{} Registering client network message {} with {} ({})", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), (Object)messageID, (Object)registrationID);
    }

    default public void logRegisterServerNetworkMessageHandler(class_2960 messageID, Class<?> networkMessage) {
        log.info("{} Registering server network message {} with {}", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), (Object)messageID);
    }

    default public void logRegisterServerNetworkMessageHandler(class_2960 messageID, Class<?> networkMessage, int registrationID) {
        log.info("{} Registering server network message {} with {} ({})", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), (Object)messageID, (Object)registrationID);
    }
}

