/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.message.client.OpenMenuCallbackMessage;
import de.markusbordihn.easynpc.network.message.client.SyncDataMessage;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ClientNetworkMessageHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    default public void openMenu(UUID uuid, UUID menuId, class_3222 serverPlayer, class_2487 data) {
        if (uuid != null && menuId != null && serverPlayer != null) {
            log.debug("Open menu {} for npc {} and player {} with: {}", (Object)menuId, (Object)uuid, (Object)serverPlayer, (Object)data);
            NetworkHandlerManager.sendMessageToPlayer(new OpenMenuCallbackMessage(uuid, menuId, data), serverPlayer);
        }
    }

    default public void syncData(EasyNPC<?> easyNPC, class_3222 serverPlayer) {
        if (easyNPC != null && serverPlayer != null) {
            log.debug("Sync {} data to player {}", easyNPC, (Object)serverPlayer);
            NetworkHandlerManager.sendMessageToPlayer(new SyncDataMessage(easyNPC.getEntityUUID(), easyNPC.getEasyNPCDialogData() != null ? easyNPC.getEasyNPCDialogData().getDialogDataSet() : null), serverPlayer);
        }
    }
}

