/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.message.server.ExecuteActionEventMessage;
import de.markusbordihn.easynpc.network.message.server.ExecuteDialogButtonActionMessage;
import de.markusbordihn.easynpc.network.message.server.OpenMenuMessage;
import de.markusbordihn.easynpc.network.message.server.RequestDataSyncMessage;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ServerNetworkMessageHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    default public void executeActionEvent(UUID uuid, ActionEventType actionEventType) {
        if (uuid != null && actionEventType != null && actionEventType != ActionEventType.NONE) {
            NetworkHandlerManager.sendMessageToServer(new ExecuteActionEventMessage(uuid, actionEventType));
        }
    }

    default public void executeDialogButtonAction(UUID uuid, UUID dialogId, UUID dialogButtonId) {
        if (uuid != null && dialogId != null && dialogButtonId != null) {
            NetworkHandlerManager.sendMessageToServer(new ExecuteDialogButtonActionMessage(uuid, dialogId, dialogButtonId));
        }
    }

    default public void openMenu(UUID uuid, UUID menuId) {
        if (uuid != null && menuId != null) {
            NetworkHandlerManager.sendMessageToServer(new OpenMenuMessage(uuid, menuId));
        }
    }

    default public void requestDataSync(UUID uuid) {
        if (uuid != null) {
            NetworkHandlerManager.sendMessageToServer(new RequestDataSyncMessage(uuid));
        }
    }
}

