/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ExecuteActionEventMessage(UUID uuid, ActionEventType actionEventType) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "trigger_action_event");

    public static ExecuteActionEventMessage create(class_2540 buffer) {
        return new ExecuteActionEventMessage(buffer.method_10790(), (ActionEventType)buffer.method_10818(ActionEventType.class));
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.actionEventType);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPC(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.actionEventType == null || this.actionEventType == ActionEventType.NONE) {
            log.error("Invalid action event type {} for {} from {}", (Object)this.actionEventType, easyNPC, (Object)serverPlayer);
            return;
        }
        ActionEventDataCapable actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("Unable to get valid action event data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ActionDataSet actionDataSet = actionEventData.getActionEventSet().getActionEvents(this.actionEventType);
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            log.error("Empty trigger action event {} request for {} from {}", (Object)this.actionEventType, easyNPC, (Object)serverPlayer);
            return;
        }
        ActionHandler actionHandler = easyNPC.getEasyNPCActionHandler();
        if (actionHandler == null) {
            log.error("Unable to get valid action handler for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        actionHandler.executeActions(actionDataSet, serverPlayer);
    }
}

